/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.item.util;

import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.zepalesque.redux.Redux;
import net.zepalesque.redux.misc.ReduxTags;
import net.zepalesque.redux.network.ReduxPacketHandler;
import net.zepalesque.redux.network.packet.InfusionExpirePacket;

public interface VeridiumItem {
    public static final byte MAXIUMUM_VERIDIUM_INFUSION = 64;
    public static final int CHARGED_DAMAGE_MULTIPLIER = 4;
    public static final String nbt_tag = "ambrosium_charge";

    public static CompoundTag createCompoundFor(ItemStack stack) {
        return stack.m_41782_() ? stack.m_41784_().m_6426_() : new CompoundTag();
    }

    public static ItemStack depleteInfusion(ItemStack stack, @Nullable LivingEntity user) {
        Item item = stack.m_41720_();
        if (item instanceof VeridiumItem) {
            byte newCharge;
            VeridiumItem virydium = (VeridiumItem)item;
            Item itemForStack = stack.m_41720_();
            CompoundTag compound = VeridiumItem.createCompoundFor(stack);
            byte ambrosiumCharge = compound.m_128445_(nbt_tag);
            if (ambrosiumCharge > 1) {
                newCharge = (byte)(ambrosiumCharge - 1);
            } else {
                newCharge = 0;
                itemForStack = virydium.getReplacementItem(stack);
                if (user != null && user instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)user;
                    ReduxPacketHandler.sendToPlayer(new InfusionExpirePacket(), player);
                }
            }
            compound.m_128344_(nbt_tag, newCharge);
            ItemStack newStack = new ItemStack((ItemLike)itemForStack, 1);
            newStack.m_41751_(compound);
            return newStack;
        }
        return stack;
    }

    public static ItemStack infuse(ItemStack stack, int amount) {
        if (amount == 0) {
            return stack;
        }
        Item item = stack.m_41720_();
        CompoundTag compound = VeridiumItem.createCompoundFor(stack);
        byte ambrosiumCharge = VeridiumItem.getInfusion(stack);
        if (ambrosiumCharge <= 64 - amount) {
            byte newCharge = (byte)(ambrosiumCharge + amount);
            compound.m_128344_(nbt_tag, newCharge);
            ItemStack i = new ItemStack((ItemLike)item);
            i.m_41751_(compound);
            return i;
        }
        return null;
    }

    public static byte getInfusion(ItemStack stack) {
        CompoundTag compound;
        CompoundTag compoundTag = compound = stack.m_41782_() ? stack.m_41784_().m_6426_() : new CompoundTag();
        if (!(stack.m_41720_() instanceof VeridiumItem)) {
            Redux.LOGGER.warn("Attempting to get infusion level of non-veridium item! Reading NBT data anyway");
        }
        return compound.m_128445_(nbt_tag);
    }

    public Item getReplacementItem(ItemStack var1);

    default public boolean isInfused(ItemStack stack) {
        return stack.m_204117_(ReduxTags.Items.INFUSED_VERIDIUM_ITEMS);
    }

    default public boolean isInfused(Item item) {
        return item.m_204114_().m_203656_(ReduxTags.Items.INFUSED_VERIDIUM_ITEMS);
    }
}

