/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.item.misc;

import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class ReduxBoatItem
extends Item {
    public final BiFunction<Level, HitResult, ? extends Boat> boatCreator;
    private static final Predicate<Entity> ENTITY_PREDICATE = EntitySelector.f_20408_.and(Entity::m_6087_);
    private final boolean hasChest;

    public ReduxBoatItem(boolean hasChest, Item.Properties properties, BiFunction<Level, HitResult, ? extends Boat> boat) {
        super(properties);
        this.hasChest = hasChest;
        this.boatCreator = boat;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack heldStack = player.m_21120_(hand);
        BlockHitResult hitResult = ReduxBoatItem.m_41435_((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.ANY);
        if (hitResult.m_6662_() == HitResult.Type.MISS) {
            return InteractionResultHolder.m_19098_((Object)heldStack);
        }
        Vec3 viewVector = player.m_20252_(1.0f);
        List list = level.m_6249_((Entity)player, player.m_20191_().m_82369_(viewVector.m_82490_(5.0)).m_82400_(1.0), ENTITY_PREDICATE);
        if (!list.isEmpty()) {
            Vec3 eyePosition = player.m_146892_();
            for (Entity entity : list) {
                AABB aabb = entity.m_20191_().m_82400_((double)entity.m_6143_());
                if (!aabb.m_82390_(eyePosition)) continue;
                return InteractionResultHolder.m_19098_((Object)heldStack);
            }
        }
        if (hitResult.m_6662_() == HitResult.Type.BLOCK) {
            Boat boat = this.getBoat(level, (HitResult)hitResult);
            boat.m_146922_(player.m_146908_());
            if (!level.m_45756_((Entity)boat, boat.m_20191_())) {
                return InteractionResultHolder.m_19100_((Object)heldStack);
            }
            if (!level.m_5776_()) {
                level.m_7967_((Entity)boat);
                level.m_142346_((Entity)player, GameEvent.f_157810_, new BlockPos(hitResult.m_82450_()));
                if (!player.m_150110_().f_35937_) {
                    heldStack.m_41774_(1);
                }
            }
            player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            return InteractionResultHolder.m_19092_((Object)heldStack, (boolean)level.m_5776_());
        }
        return InteractionResultHolder.m_19098_((Object)heldStack);
    }

    private Boat getBoat(Level level, HitResult hitResult) {
        return this.boatCreator.apply(level, hitResult);
    }
}

