/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.client.resource;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.AbstractPackResources;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.ResourcePackFileNotFoundException;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.zepalesque.redux.api.Conditional;
import net.zepalesque.redux.builtin.BuiltinPackUtils;
import org.apache.commons.compress.utils.Lists;

public class ReduxOverridesPackResources
extends AbstractPackResources {
    private final List<Conditional<PackResources>> delegates;
    private Map<String, List<Conditional<PackResources>>> namespacesAssets;
    private final Path source;
    private final String id;
    private final PackMetadataSection packInfo;
    private static final Gson GSON = new Gson();

    public ReduxOverridesPackResources(String id, PackMetadataSection packInfo, List<Conditional<PackResources>> packs) {
        super(new File(id));
        this.id = id;
        this.source = BuiltinPackUtils.path(id);
        this.packInfo = packInfo;
        this.delegates = ImmutableList.copyOf(packs);
        this.namespacesAssets = this.buildNamespaceMap(PackType.CLIENT_RESOURCES, this.delegates);
    }

    public Path getSource() {
        return this.source;
    }

    public void initForNamespace(String nameSpace) {
        this.delegates.forEach(delegate -> ((PackResources)delegate.getAnyway()).initForNamespace(nameSpace));
    }

    public void init(PackType packType) {
        this.delegates.forEach(packResources -> ((PackResources)packResources.getAnyway()).init(packType));
        this.namespacesAssets = this.buildNamespaceMap(PackType.CLIENT_RESOURCES, this.delegates);
    }

    private Map<String, List<Conditional<PackResources>>> buildNamespaceMap(PackType type, List<Conditional<PackResources>> packList) {
        HashMap<String, List> map = new HashMap<String, List>();
        for (Conditional<PackResources> optional : packList) {
            if (!optional.isPopulated()) continue;
            PackResources pack = optional.getAnyway();
            for (String namespace : pack.m_5698_(type)) {
                map.computeIfAbsent(namespace, k -> new ArrayList()).add(optional);
            }
        }
        map.replaceAll((k, list) -> ImmutableList.copyOf((Collection)list));
        return ImmutableMap.copyOf(map);
    }

    public String m_8017_() {
        return this.id;
    }

    public <T> T m_5550_(MetadataSectionSerializer<T> deserializer) throws IOException {
        if (deserializer.m_7991_().equals("pack")) {
            return (T)this.packInfo;
        }
        return null;
    }

    public Collection<ResourceLocation> m_214146_(PackType type, String pathIn, String pathIn2, Predicate<ResourceLocation> filter) {
        return this.getAvaliablePacks().stream().flatMap(r -> r.m_214146_(type, pathIn, pathIn2, filter).stream()).collect(Collectors.toList());
    }

    public Collection<PackResources> getAvaliablePacks() {
        return this.delegates.stream().filter(Conditional::isAvailable).map(Conditional::get).toList();
    }

    public Collection<PackResources> getAllPacks() {
        return this.delegates.stream().filter(Conditional::isPopulated).map(Conditional::getAnyway).toList();
    }

    public Set<String> m_5698_(PackType type) {
        return type == PackType.CLIENT_RESOURCES ? this.namespacesAssets.keySet() : Set.of();
    }

    public void close() {
        for (PackResources pack : this.getAllPacks()) {
            pack.close();
        }
    }

    public InputStream m_5542_(String pFileName) throws IOException {
        if (!pFileName.contains("/") && !pFileName.contains("\\")) {
            return this.m_5541_(pFileName);
        }
        throw new IllegalArgumentException("Root resources can only be filenames, not paths (no / allowed!)");
    }

    protected Path resolve(String ... paths) {
        Path path = this.getSource();
        String[] var3 = paths;
        int var4 = paths.length;
        for (int var5 = 0; var5 < var4; ++var5) {
            String name = var3[var5];
            path = path.resolve(name);
        }
        return path;
    }

    protected boolean m_6105_(@Nonnull String name) {
        Path path = this.resolve(name);
        return Files.exists(path, new LinkOption[0]);
    }

    @Nonnull
    protected InputStream m_5541_(@Nonnull String name) throws IOException {
        Path path = this.resolve(name);
        if (!Files.exists(path, new LinkOption[0])) {
            throw new FileNotFoundException("Can't find resource " + name + " at " + this.getSource());
        }
        return Files.newInputStream(path, StandardOpenOption.READ);
    }

    public InputStream m_8031_(PackType type, ResourceLocation location) throws IOException {
        if (location.m_135815_().matches("lang/.+\\.json") || location.m_135815_().matches(".*sounds\\.json")) {
            ArrayList matches = Lists.newArrayList();
            JsonObject combined = new JsonObject();
            for (PackResources pack : this.getCandidatePacks(type, location)) {
                if (!pack.m_7211_(type, location)) continue;
                InputStream iStream = pack.m_8031_(type, location);
                JsonObject jsonobject = (JsonObject)GSON.fromJson((Reader)new InputStreamReader(iStream, StandardCharsets.UTF_8), JsonObject.class);
                matches.add(jsonobject.entrySet());
            }
            if (!matches.isEmpty()) {
                for (Set entrySet : matches) {
                    for (Map.Entry entry : entrySet) {
                        combined.add((String)entry.getKey(), (JsonElement)entry.getValue());
                    }
                }
            } else {
                throw new ResourcePackFileNotFoundException(this.f_10203_, ReduxOverridesPackResources.getFullPath(type, location));
            }
            String input = GSON.toJson((JsonElement)combined);
            return new ByteArrayInputStream(input.getBytes(StandardCharsets.UTF_8));
        }
        for (PackResources pack : this.getCandidatePacks(type, location)) {
            if (!pack.m_7211_(type, location)) continue;
            return pack.m_8031_(type, location);
        }
        throw new ResourcePackFileNotFoundException(this.f_10203_, ReduxOverridesPackResources.getFullPath(type, location));
    }

    public boolean m_7211_(PackType type, ResourceLocation location) {
        for (PackResources pack : this.getCandidatePacks(type, location)) {
            if (!pack.m_7211_(type, location)) continue;
            return true;
        }
        return false;
    }

    private List<PackResources> getCandidatePacks(PackType type, ResourceLocation location) {
        if (type == PackType.CLIENT_RESOURCES) {
            Map<String, List<Conditional<PackResources>>> map = this.namespacesAssets;
            List<Conditional<PackResources>> packsWithNamespace = map.get(location.m_135827_());
            return packsWithNamespace == null ? Collections.emptyList() : packsWithNamespace.stream().filter(Conditional::isAvailable).map(Conditional::get).toList();
        }
        return Collections.emptyList();
    }

    private static String getFullPath(PackType type, ResourceLocation location) {
        return String.format(Locale.ROOT, "%s/%s/%s", type.m_10305_(), location.m_135827_(), location.m_135815_());
    }
}

