/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.client.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import javax.annotation.Nonnull;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import net.zepalesque.redux.block.ReduxBlocks;
import net.zepalesque.redux.block.container.SkyrootChestBlock;
import net.zepalesque.redux.block.container.SkyrootChestMimicBlock;
import net.zepalesque.redux.client.render.ReduxAtlases;
import net.zepalesque.redux.client.render.ReduxModelLayers;

public class SkyrootChestMimicRenderer<T extends BlockEntity>
implements BlockEntityRenderer<T> {
    private final ModelPart lid;
    private final ModelPart bottom;
    private final ModelPart lock;

    public SkyrootChestMimicRenderer(BlockEntityRendererProvider.Context context) {
        ModelPart root = context.m_173582_(ReduxModelLayers.SKYROOT_CHEST_MIMIC);
        this.bottom = root.m_171324_("bottom");
        this.lid = root.m_171324_("lid");
        this.lock = root.m_171324_("lock");
    }

    public void m_6922_(T blockEntity, float partialTicks, @Nonnull PoseStack poseStack, @Nonnull MultiBufferSource buffer, int packedLight, int packedOverlay) {
        BlockState blockState;
        BlockState blockState2 = blockState = blockEntity.m_58904_() != null ? blockEntity.m_58900_() : (BlockState)((Block)ReduxBlocks.SKYROOT_CHEST_MIMIC.get()).m_49966_().m_61124_((Property)SkyrootChestBlock.f_51478_, (Comparable)Direction.SOUTH);
        if (blockState.m_60734_() instanceof SkyrootChestMimicBlock) {
            poseStack.m_85836_();
            float f = ((Direction)blockState.m_61143_((Property)SkyrootChestBlock.f_51478_)).m_122435_();
            poseStack.m_85837_(0.5, 0.5, 0.5);
            poseStack.m_85845_(Vector3f.f_122225_.m_122240_(-f));
            poseStack.m_85837_(-0.5, -0.5, -0.5);
            Material material = this.getMaterial();
            VertexConsumer vertexconsumer = material.m_119194_(buffer, RenderType::m_110452_);
            this.render(poseStack, vertexconsumer, this.lid, this.lock, this.bottom, packedLight, packedOverlay);
            poseStack.m_85849_();
        }
    }

    private void render(PoseStack poseStack, VertexConsumer consumer, ModelPart chestLid, ModelPart chestLatch, ModelPart chestBottom, int packedLight, int packedOverlay) {
        chestLid.m_104301_(poseStack, consumer, packedLight, packedOverlay);
        chestLatch.m_104301_(poseStack, consumer, packedLight, packedOverlay);
        chestBottom.m_104301_(poseStack, consumer, packedLight, packedOverlay);
    }

    private static Material chooseMaterial(ChestType ct, Material pDoubleMaterial, Material pLeftMaterial, Material pRightMaterial) {
        if (ct == ChestType.LEFT) {
            return pLeftMaterial;
        }
        if (ct == ChestType.RIGHT) {
            return pRightMaterial;
        }
        if (ct == ChestType.SINGLE) {
            return pDoubleMaterial;
        }
        return pDoubleMaterial;
    }

    protected Material getMaterial() {
        return SkyrootChestMimicRenderer.chooseMaterial(ChestType.SINGLE, ReduxAtlases.SKYROOT_CHEST_MATERIAL, ReduxAtlases.SKYROOT_CHEST_LEFT_MATERIAL, ReduxAtlases.SKYROOT_CHEST_RIGHT_MATERIAL);
    }
}

