/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.client.event.listener;

import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundEngine;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.zepalesque.redux.client.audio.ReduxSoundEvents;
import net.zepalesque.redux.client.event.hook.ReduxAudioHooks;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class ReduxAudioListener {
    @Nullable
    private static SoundEngine se = null;

    @SubscribeEvent
    public static void onPlaySound(PlaySoundEvent event) {
        SoundInstance sound;
        SoundEngine soundEngine = event.getEngine();
        if (se != soundEngine) {
            se = soundEngine;
        }
        if (ReduxAudioHooks.shouldCancel(soundEngine, sound = event.getOriginalSound())) {
            event.setSound(null);
            return;
        }
        if (ReduxAudioHooks.shouldCancelAercloudSound(sound)) {
            event.setSound(null);
            return;
        }
        if (ReduxAudioHooks.shouldCancelPortalSound(soundEngine, sound)) {
            event.setSound(null);
            return;
        }
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level != null) {
            RandomSource random = level.m_213780_();
            if (ReduxAudioHooks.shouldReplacePortalHum(sound)) {
                event.setSound((SoundInstance)new SimpleSoundInstance((SoundEvent)ReduxSoundEvents.PORTAL_HUM.get(), SoundSource.BLOCKS, 0.5f, random.m_188501_() * 0.4f + 0.8f, RandomSource.m_216335_((long)random.m_188505_()), sound.m_7772_(), sound.m_7780_(), sound.m_7778_()));
                return;
            }
            if (ReduxAudioHooks.shouldReplacePortalTrigger(sound)) {
                event.setSound((SoundInstance)new SimpleSoundInstance((SoundEvent)ReduxSoundEvents.PORTAL_TRIGGER.get(), SoundSource.BLOCKS, 0.25f, random.m_188501_() * 0.4f + 0.8f, RandomSource.m_216335_((long)random.m_188505_()), sound.m_7772_(), sound.m_7780_(), sound.m_7778_()));
                return;
            }
            if (ReduxAudioHooks.shouldReplacePortalTravel(sound)) {
                event.setSound((SoundInstance)new SimpleSoundInstance((SoundEvent)ReduxSoundEvents.PORTAL_TRAVEL.get(), SoundSource.BLOCKS, 0.25f, random.m_188501_() * 0.4f + 0.8f, RandomSource.m_216335_((long)random.m_188505_()), sound.m_7772_(), sound.m_7780_(), sound.m_7778_()));
                return;
            }
        }
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ReduxAudioHooks.tick();
        }
    }

    @SubscribeEvent
    public static void onPlayerRespawn(ClientPlayerNetworkEvent.Clone event) {
        ReduxAudioHooks.stop();
    }
}

