/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.capability.player;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.util.INBTSerializable;
import net.zepalesque.redux.Redux;

public class LoreBookModule
implements INBTSerializable {
    private Map<EntityType<?>, Integer> entities = new HashMap();
    private Collection<Item> unlockedItems = new ArrayList<Item>();
    private Map<ResourceLocation, Integer> biomes = new HashMap<ResourceLocation, Integer>();

    public void incrementEntity(EntityType<?> entityType) {
        if (this.entities.containsKey(entityType)) {
            int i = this.entities.get(entityType) + 1;
            this.entities.put(entityType, i);
        } else {
            this.entities.put(entityType, 1);
        }
    }

    public void unlock(Item item) {
        if (!this.unlockedItems.contains(item)) {
            this.unlockedItems.add(item);
        }
    }

    public void incrementBiome(ResourceLocation biome) {
        if (this.biomes.containsKey(biome)) {
            int i = this.biomes.get(biome) + 1;
            this.biomes.put(biome, i);
        } else {
            this.biomes.put(biome, 1);
        }
    }

    public Tag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        CompoundTag mobs = new CompoundTag();
        for (Map.Entry<EntityType<?>, Integer> entry : this.entities.entrySet()) {
            mobs.m_128405_(Registry.f_122826_.m_7981_(entry.getKey()).toString(), entry.getValue().intValue());
        }
        tag.m_128365_("entity", (Tag)mobs);
        CompoundTag b = new CompoundTag();
        for (Map.Entry<ResourceLocation, Integer> entry : this.biomes.entrySet()) {
            b.m_128405_(entry.getKey().toString(), entry.getValue().intValue());
        }
        tag.m_128365_("biome", (Tag)b);
        List<String> list = this.unlockedItems.stream().map(arg_0 -> ((DefaultedRegistry)Registry.f_122827_).m_7981_(arg_0)).map(ResourceLocation::toString).toList();
        String string = String.join((CharSequence)",", list);
        tag.m_128359_("item", string);
        return tag;
    }

    public void deserializeNBT(Tag nbt) {
        HashMap entities = new HashMap();
        HashMap<ResourceLocation, Integer> biomes = new HashMap<ResourceLocation, Integer>();
        ArrayList<Item> unlockedItems = new ArrayList<Item>();
        if (nbt instanceof CompoundTag) {
            String items;
            Tag b;
            CompoundTag tag = (CompoundTag)nbt;
            Tag mobs = tag.m_128423_("entity");
            if (mobs instanceof CompoundTag) {
                CompoundTag mobsTag = (CompoundTag)mobs;
                for (Object id : mobsTag.m_128431_()) {
                    ResourceLocation loc = new ResourceLocation((String)id);
                    if (Registry.f_122826_.m_7804_(loc)) {
                        entities.put((EntityType)Registry.f_122826_.m_7745_(loc), mobsTag.m_128451_((String)id));
                        continue;
                    }
                    Redux.LOGGER.warn("Could not find entity_type with id {} for Book of Lore! Skipping...", id);
                }
            }
            if ((b = tag.m_128423_("biome")) instanceof CompoundTag) {
                CompoundTag biomeTag = (CompoundTag)b;
                for (String id : biomeTag.m_128431_()) {
                    ResourceLocation loc = new ResourceLocation(id);
                    biomes.put(loc, biomeTag.m_128451_(id));
                }
            }
            if (!(items = tag.m_128461_("item")).isEmpty()) {
                String[] array;
                for (String id : array = items.split(",")) {
                    ResourceLocation loc = new ResourceLocation(id);
                    if (Registry.f_122827_.m_7804_(loc)) {
                        unlockedItems.add((Item)Registry.f_122827_.m_7745_(loc));
                        continue;
                    }
                    Redux.LOGGER.warn("Could not find item with id {} for Book of Lore! Skipping...", (Object)id);
                }
            }
        }
        this.entities = entities;
        this.unlockedItems = unlockedItems;
        this.biomes = biomes;
    }
}

