/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.block.natural.blight;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.GrowingPlantBodyBlock;
import net.minecraft.world.level.block.GrowingPlantHeadBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.zepalesque.redux.data.resource.ReduxDamageTypes;
import net.zepalesque.redux.event.hook.EquipmentHooks;
import net.zepalesque.redux.misc.ReduxTags;
import top.theillusivec4.curios.api.CuriosApi;

public class CorruptedVinesPlantBlock
extends GrowingPlantBodyBlock {
    public static final VoxelShape SHAPE = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    private final Supplier<? extends GrowingPlantHeadBlock> head;

    public CorruptedVinesPlantBlock(BlockBehaviour.Properties properties, Supplier<? extends GrowingPlantHeadBlock> head) {
        super(properties, Direction.UP, SHAPE, false);
        this.head = head;
    }

    public void m_7892_(BlockState pState, Level pLevel, BlockPos pPos, Entity pEntity) {
        LivingEntity living;
        if (!pEntity.f_19853_.m_5776_() && pEntity instanceof LivingEntity && !(living = (LivingEntity)pEntity).m_6095_().m_204039_(ReduxTags.EntityTypes.BLIGHTED_MOBS) && living.m_20191_().m_82381_(this.m_5940_(pState, (BlockGetter)pLevel, pPos, CollisionContext.m_82750_((Entity)living)).m_83215_().m_82338_(pPos))) {
            if (!EquipmentHooks.isImmuneToBlightPlants(living)) {
                pEntity.m_7601_(pState, new Vec3(1.0, 1.0, 1.0));
                if (!(pLevel.f_46443_ || pEntity.f_19790_ == pEntity.m_20185_() && pEntity.f_19792_ == pEntity.m_20189_())) {
                    double d0 = Math.abs(pEntity.m_20185_() - pEntity.f_19790_);
                    double d1 = Math.abs(pEntity.m_20189_() - pEntity.f_19792_);
                    if (d0 >= (double)0.003f || d1 >= (double)0.003f) {
                        pEntity.m_6469_(ReduxDamageTypes.CORRUPTED_VINES, 3.0f);
                    }
                }
            }
            if (pLevel.f_46441_.m_188503_(100) == 0) {
                CuriosApi.getCuriosHelper().findFirstCurio(living, stack -> stack.m_204117_(ReduxTags.Items.BLIGHTWARDING_ACCESSORIES)).ifPresent(slotResult -> slotResult.stack().m_41622_(1, slotResult.slotContext().entity(), livingEntity -> CuriosApi.getCuriosHelper().onBrokenCurio(slotResult.slotContext())));
            }
        }
    }

    public boolean isLadder(BlockState state, LevelReader level, BlockPos pos, LivingEntity entity) {
        return super.isLadder(state, level, pos, entity) && EquipmentHooks.isImmuneToBlightPlants(entity);
    }

    protected GrowingPlantHeadBlock m_7272_() {
        return this.head.get();
    }
}

