/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.itemfilters;

import dev.latvian.mods.itemfilters.api.IItemFilter;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class DisplayStacksCache {
    private static final int MAX_CACHE_SIZE = 1024;
    private static final Object2ObjectLinkedOpenHashMap<CacheKey, List<ItemStack>> cache = new Object2ObjectLinkedOpenHashMap(1024);
    private static final NonNullList<ItemStack> allKnownStacks = NonNullList.m_122779_();

    @Nonnull
    public static List<ItemStack> getCachedDisplayStacks(ItemStack filterStack) {
        CacheKey key = new CacheKey(filterStack);
        List<ItemStack> result = (List<ItemStack>)cache.getAndMoveToFirst((Object)key);
        if (result == null) {
            result = DisplayStacksCache.computeMatchingStacks(filterStack);
            cache.put((Object)key, result);
            if (cache.size() >= 1024) {
                cache.removeLast();
            }
        }
        return result;
    }

    private static List<ItemStack> computeMatchingStacks(ItemStack filterStack) {
        if (allKnownStacks.isEmpty()) {
            for (Item item : Registry.f_122827_) {
                try {
                    item.m_6787_(CreativeModeTab.f_40754_, allKnownStacks);
                }
                catch (Throwable throwable) {}
            }
        }
        IItemFilter f = (IItemFilter)filterStack.m_41720_();
        return allKnownStacks.stream().filter(candidate -> f.filter(filterStack, (ItemStack)candidate)).toList();
    }

    public static void clear() {
        cache.clear();
    }

    private static class CacheKey {
        private final int key;

        private CacheKey(ItemStack filterStack) {
            this.key = Objects.hash(Registry.f_122827_.m_7447_((Object)filterStack.m_41720_()), filterStack.m_41782_() ? filterStack.m_41783_().hashCode() : 0);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return this.key == cacheKey.key;
        }

        public int hashCode() {
            return Integer.hashCode(this.key);
        }
    }
}

