/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.util;

import com.jozufozu.flywheel.core.PartialModel;
import com.jozufozu.flywheel.util.transform.TransformStack;
import com.mojang.blaze3d.vertex.PoseStack;
import com.railwayteam.railways.mixin_interfaces.IHasTrackCasing;
import com.railwayteam.railways.registry.CRBlockPartials;
import com.railwayteam.railways.registry.CRTrackMaterials;
import com.simibubi.create.content.schematics.SchematicWorld;
import com.simibubi.create.content.trains.graph.EdgePointType;
import com.simibubi.create.content.trains.graph.TrackEdge;
import com.simibubi.create.content.trains.graph.TrackGraphLocation;
import com.simibubi.create.content.trains.graph.TrackNodeLocation;
import com.simibubi.create.content.trains.signal.TrackEdgePoint;
import com.simibubi.create.content.trains.track.BezierConnection;
import com.simibubi.create.content.trains.track.BezierTrackPointLocation;
import com.simibubi.create.content.trains.track.ITrackBlock;
import com.simibubi.create.content.trains.track.TrackBlock;
import com.simibubi.create.content.trains.track.TrackBlockEntity;
import com.simibubi.create.content.trains.track.TrackRenderer;
import com.simibubi.create.content.trains.track.TrackShape;
import com.simibubi.create.content.trains.track.TrackTargetingBehaviour;
import com.simibubi.create.foundation.ponder.PonderWorld;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class CustomTrackOverlayRendering {
    public static final Map<EdgePointType<?>, PartialModel> CUSTOM_OVERLAYS = new HashMap();

    public static void register(EdgePointType<?> edgePointType, PartialModel model) {
        CUSTOM_OVERLAYS.put(edgePointType, model);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderOverlay(LevelAccessor level, BlockPos pos, Direction.AxisDirection direction, BezierTrackPointLocation bezier, PoseStack ms, MultiBufferSource buffer, int light, int overlay, EdgePointType<?> type, float scale) {
        if (CUSTOM_OVERLAYS.containsKey(type)) {
            CustomTrackOverlayRendering.renderOverlay(level, pos, direction, bezier, ms, buffer, light, overlay, CUSTOM_OVERLAYS.get(type), scale, false);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderOverlay(LevelAccessor level, BlockPos pos, Direction.AxisDirection direction, BezierTrackPointLocation bezier, PoseStack ms, MultiBufferSource buffer, int light, int overlay, PartialModel model, float scale) {
        CustomTrackOverlayRendering.renderOverlay(level, pos, direction, bezier, ms, buffer, light, overlay, model, scale, false);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderOverlay(LevelAccessor level, BlockPos pos, Direction.AxisDirection direction, BezierTrackPointLocation bezier, PoseStack ms, MultiBufferSource buffer, int light, int overlay, PartialModel model, float scale, boolean offsetToSide) {
        if (level instanceof SchematicWorld && !(level instanceof PonderWorld)) {
            return;
        }
        BlockState trackState = level.m_8055_(pos);
        Block block = trackState.m_60734_();
        if (!(block instanceof ITrackBlock)) {
            return;
        }
        ms.m_85836_();
        PartialModel partial = CustomTrackOverlayRendering.prepareTrackOverlay((BlockGetter)level, pos, trackState, bezier, direction, ms, model);
        if (partial != null) {
            ((SuperByteBuffer)CachedBufferer.partial((PartialModel)partial, (BlockState)trackState).translate(0.5, 0.0, 0.5).scale(scale)).translate(offsetToSide ? 0.5 : -0.5, 0.0, -0.5).light(LevelRenderer.m_109541_((BlockAndTintGetter)level, (BlockPos)pos)).renderInto(ms, buffer.m_6299_(RenderType.m_110457_()));
        }
        ms.m_85849_();
    }

    /*
     * Unable to fully structure code
     */
    @OnlyIn(value=Dist.CLIENT)
    public static PartialModel prepareTrackOverlay(BlockGetter world, BlockPos pos, BlockState state, BezierTrackPointLocation bezierPoint, Direction.AxisDirection direction, PoseStack ms, PartialModel model) {
        msr = TransformStack.cast((PoseStack)ms);
        axis = null;
        diff = null;
        normal = null;
        offset = null;
        if (bezierPoint != null && (var13_12 = world.m_7702_(pos)) instanceof TrackBlockEntity) {
            trackTE = (TrackBlockEntity)var13_12;
            bc = (BezierConnection)trackTE.getConnections().get(bezierPoint.curveTarget());
            if (bc != null) {
                length = Mth.m_14107_((double)(bc.getLength() * 2.0));
                seg = bezierPoint.segment() + 1;
                t = (double)seg / length;
                tpre = (double)(seg - 1) / length;
                tpost = (double)(seg + 1) / length;
                offset = bc.getPosition(t);
                normal = bc.getNormal(t);
                diff = bc.getPosition(tpost).m_82546_(bc.getPosition(tpre)).m_82541_();
                msr.translate(offset.m_82546_(Vec3.m_82539_((Vec3i)pos)));
                msr.translate(0.0, -0.25, 0.0);
                casingBc = (IHasTrackCasing)bc;
                if (bc.getMaterial().trackType == CRTrackMaterials.CRTrackType.MONORAIL) {
                    msr.translate(0.0, 0.875, 0.0);
                } else if (casingBc.getTrackCasing() != null) {
                    if (((BlockPos)bc.tePositions.getFirst()).m_123342_() == ((BlockPos)bc.tePositions.getSecond()).m_123342_()) {
                        msr.translate(0.0, 0.0625, 0.0);
                    } else if (!casingBc.isAlternate()) {
                        msr.translate(0.0, 0.25, 0.0);
                    }
                }
            } else {
                return null;
            }
        }
        if (normal == null) {
            axis = (Vec3)((TrackShape)state.m_61143_((Property)TrackBlock.SHAPE)).getAxes().get(0);
            diff = axis.m_82490_((double)direction.m_122540_()).m_82541_();
            normal = ((ITrackBlock)state.m_60734_()).getUpNormal(world, pos, state);
        }
        if (bezierPoint != null || !((var15_27 = state.m_60734_()) instanceof TrackBlock)) ** GOTO lbl-1000
        trackBlock = (TrackBlock)var15_27;
        if (trackBlock.getMaterial().trackType == CRTrackMaterials.CRTrackType.MONORAIL) {
            msr.translate(0.0, 0.875, 0.0);
        } else if (bezierPoint == null && (var15_27 = world.m_7702_(pos)) instanceof TrackBlockEntity) {
            trackTE = (TrackBlockEntity)var15_27;
            var15_27 = state.m_60734_();
            if (var15_27 instanceof TrackBlock) {
                trackBlock = (TrackBlock)var15_27;
                casingTE = (IHasTrackCasing)trackTE;
                shape = (TrackShape)state.m_61143_((Property)TrackBlock.SHAPE);
                if (casingTE.getTrackCasing() != null) {
                    spec = CRBlockPartials.TRACK_CASINGS.get(shape);
                    trackType = trackBlock.getMaterial().trackType;
                    if (spec != null) {
                        msr.translate(spec.getXShift(trackType), (double)((float)(spec.getTopSurfacePixelHeight(trackType, casingTE.isAlternate()) - 2) / 16.0f), spec.getZShift(trackType));
                    }
                }
            }
        }
        angles = TrackRenderer.getModelAngles(normal, diff);
        ((TransformStack)((TransformStack)((TransformStack)msr.centre()).rotateYRadians(angles.f_82480_)).rotateXRadians(angles.f_82479_)).unCentre();
        if (axis != null) {
            msr.translate(0.0, axis.f_82480_ != 0.0 ? 0.4375 : 0.0, axis.f_82480_ != 0.0 ? (double)((float)direction.m_122540_() * 2.5f / 16.0f) : 0.0);
        } else {
            msr.translate(0.0, 0.25, 0.0);
            if (direction == Direction.AxisDirection.NEGATIVE) {
                msr.rotateCentered(Direction.UP, 3.1415927f);
            }
        }
        if (bezierPoint == null && (trackBlock = world.m_7702_(pos)) instanceof TrackBlockEntity && (trackTE = (TrackBlockEntity)trackBlock).isTilted()) {
            yOffset = 0.0;
            for (BezierConnection bc : trackTE.getConnections().values()) {
                yOffset += ((Vec3)bc.starts.getFirst()).f_82480_ - (double)pos.m_123342_();
            }
            ((TransformStack)((TransformStack)((TransformStack)msr.centre()).rotateX((double)(-direction.m_122540_()) * (Double)trackTE.tilt.smoothingAngle.get())).unCentre()).translate(0.0, yOffset / 2.0, 0.0);
        }
        return model;
    }

    public static boolean overlayWillOverlap(TrackTargetingBehaviour<? extends TrackEdgePoint> target) {
        try {
            TrackGraphLocation graphLocation = target.determineGraphLocation();
            TrackEdge edge = (TrackEdge)graphLocation.graph.getConnectionsFrom(graphLocation.graph.locateNode((TrackNodeLocation)graphLocation.edge.getFirst())).get(graphLocation.graph.locateNode((TrackNodeLocation)graphLocation.edge.getSecond()));
            for (TrackEdgePoint edgePoint : edge.getEdgeData().getPoints()) {
                try {
                    double d = edgePoint.getLocationOn(edge);
                    double d2 = target.getEdgePoint() != null ? target.getEdgePoint().getLocationOn(edge) : graphLocation.position;
                    if (!(Math.abs(d - d2) < 0.75) || edgePoint == target.getEdgePoint() || edgePoint.getId().equals(target.getEdgePoint().getId())) continue;
                    return true;
                }
                catch (Exception exception) {
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

