/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.base.data.recipe;

import com.railwayteam.railways.Railways;
import com.railwayteam.railways.multiloader.CommonTags;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.Registry;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.NotNull;

public abstract class RailwaysRecipeProvider
extends RecipeProvider {
    protected final List<GeneratedRecipe> all = new ArrayList<GeneratedRecipe>();

    public RailwaysRecipeProvider(DataGenerator pGenerator) {
        super(pGenerator);
    }

    public void registerRecipes(@NotNull Consumer<FinishedRecipe> p_200404_1_) {
        this.all.forEach(c -> c.register(p_200404_1_));
        Railways.LOGGER.info(this.m_6055_() + " registered " + this.all.size() + " recipe" + (this.all.size() == 1 ? "" : "s"));
    }

    protected GeneratedRecipe register(GeneratedRecipe recipe) {
        this.all.add(recipe);
        return recipe;
    }

    @FunctionalInterface
    public static interface GeneratedRecipe {
        public void register(Consumer<FinishedRecipe> var1);
    }

    public static class Ingredients {
        public static TagKey<Item> string() {
            return CommonTags.STRING.tag;
        }

        public static ItemLike precisionMechanism() {
            return (ItemLike)AllItems.PRECISION_MECHANISM.get();
        }

        public static TagKey<Item> ironNugget() {
            return CommonTags.IRON_NUGGETS.tag;
        }

        public static TagKey<Item> ironIngot() {
            return CommonTags.IRON_INGOTS.tag;
        }

        public static TagKey<Item> zincNugget() {
            return CommonTags.ZINC_NUGGETS.tag;
        }

        public static ItemLike girder() {
            return (ItemLike)AllBlocks.METAL_GIRDER.get();
        }

        public static ItemLike metalBracket() {
            return (ItemLike)AllBlocks.METAL_BRACKET.get();
        }

        public static TagKey<Item> ironSheet() {
            return CommonTags.IRON_PLATES.tag;
        }

        public static TagKey<Item> fence() {
            return TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)new ResourceLocation("minecraft:fences"));
        }

        public static ItemLike campfire() {
            return Blocks.f_50683_;
        }

        public static ItemLike redstone() {
            return Items.f_42451_;
        }

        public static ItemLike lever() {
            return Items.f_41966_;
        }

        public static ItemLike cogwheel() {
            return (ItemLike)AllBlocks.COGWHEEL.get();
        }

        public static ItemLike railwayCasing() {
            return (ItemLike)AllBlocks.RAILWAY_CASING.get();
        }

        public static ItemLike brassCasing() {
            return (ItemLike)AllBlocks.BRASS_CASING.get();
        }

        public static ItemLike andesiteCasing() {
            return (ItemLike)AllBlocks.ANDESITE_CASING.get();
        }

        public static ItemLike propeller() {
            return (ItemLike)AllItems.PROPELLER.get();
        }

        public static ItemLike electronTube() {
            return (ItemLike)AllItems.ELECTRON_TUBE.get();
        }

        public static TagKey<Item> copperIngot() {
            return CommonTags.COPPER_INGOTS.tag;
        }

        public static TagKey<Item> brassNugget() {
            return CommonTags.BRASS_NUGGETS.tag;
        }

        public static ItemLike phantomMembrane() {
            return Items.f_42714_;
        }

        public static ItemLike eyeOfEnder() {
            return Items.f_42545_;
        }

        public static ItemLike industrialIron() {
            return (ItemLike)AllBlocks.INDUSTRIAL_IRON_BLOCK.get();
        }

        public static TagKey<Item> brassSheet() {
            return CommonTags.BRASS_PLATES.tag;
        }
    }
}

