/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createenchantmentindustry.content.contraptions.enchanting.printer;

import com.jozufozu.flywheel.core.PartialModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.blockEntity.renderer.SmartBlockEntityRenderer;
import com.simibubi.create.foundation.fluid.FluidRenderer;
import com.simibubi.create.foundation.render.CachedBufferer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fluids.FluidStack;
import plus.dragons.createenchantmentindustry.content.contraptions.enchanting.printer.PrinterBlockEntity;
import plus.dragons.createenchantmentindustry.entry.CeiBlockPartials;

public class PrinterRenderer
extends SmartBlockEntityRenderer<PrinterBlockEntity> {
    private static final PartialModel[] TUBE = new PartialModel[]{CeiBlockPartials.PRINTER_TOP, CeiBlockPartials.PRINTER_MIDDLE};

    public PrinterRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    protected void renderSafe(PrinterBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        super.renderSafe((SmartBlockEntity)be, partialTicks, ms, buffer, light, overlay);
        SmartFluidTankBehaviour tank = be.tank;
        if (tank == null) {
            return;
        }
        SmartFluidTankBehaviour.TankSegment primaryTank = tank.getPrimaryTank();
        FluidStack fluidStack = primaryTank.getRenderedFluid();
        float level = primaryTank.getFluidLevel().getValue(partialTicks);
        if (!fluidStack.isEmpty() && level != 0.0f) {
            level = Math.max(level, 0.175f);
            float min = 0.15625f;
            float max = min + 0.6875f;
            float yOffset = 0.6875f * level;
            ms.m_85836_();
            ms.m_85837_(0.0, (double)yOffset, 0.0);
            FluidRenderer.renderFluidBox((FluidStack)fluidStack, (float)min, (float)(min - yOffset), (float)min, (float)max, (float)min, (float)max, (MultiBufferSource)buffer, (PoseStack)ms, (int)light, (boolean)false);
            ms.m_85849_();
        }
        int processingTicks = be.processingTicks;
        float processingPT = (float)processingTicks - partialTicks;
        float squeeze = 0.0f;
        if (processingPT < 0.0f) {
            squeeze = 0.0f;
        } else if (processingPT <= 10.0f) {
            squeeze = Mth.m_14179_((float)(processingPT / 10.0f), (float)0.0f, (float)-1.0f);
        } else if (processingPT <= 90.0f) {
            squeeze = -1.0f;
        } else if (processingPT <= 100.0f) {
            squeeze = Mth.m_14179_((float)((100.0f - processingPT) / 10.0f), (float)0.0f, (float)-1.0f);
        }
        ms.m_85836_();
        for (PartialModel bit : TUBE) {
            ms.m_85837_(0.0, (double)(-3.0f * squeeze / 32.0f), 0.0);
            CachedBufferer.partial((PartialModel)bit, (BlockState)be.m_58900_()).light(light).renderInto(ms, buffer.m_6299_(RenderType.m_110451_()));
        }
        ms.m_85849_();
        BlockState blockState = be.m_58900_();
        CachedBufferer.partial((PartialModel)CeiBlockPartials.PRINTER_BOTTOM, (BlockState)blockState).translate(0.0, (double)(squeeze / 2.0f), 0.0).light(light).renderInto(ms, buffer.m_6299_(RenderType.m_110451_()));
    }
}

