/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.network;

import java.util.function.Supplier;
import mob_grinding_utils.tile.TileEntityMGUSpawner;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.NetworkEvent;

public class MessageEntitySpawner {
    public ResourceKey<Level> dimension;
    public int entityID;
    public int buttonID;
    public BlockPos tilePos;

    public MessageEntitySpawner(Player player, int button, BlockPos pos) {
        this.dimension = player.m_20193_().m_46472_();
        this.entityID = player.m_19879_();
        this.buttonID = button;
        this.tilePos = pos;
    }

    public MessageEntitySpawner(Player player, int button, int x, int y, int z) {
        this.dimension = player.m_20193_().m_46472_();
        this.entityID = player.m_19879_();
        this.buttonID = button;
        this.tilePos = new BlockPos(x, y, z);
    }

    public MessageEntitySpawner(ResourceLocation dimensionKey, int entityID, int buttonID, BlockPos tilePos) {
        this.dimension = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)dimensionKey);
        this.entityID = entityID;
        this.buttonID = buttonID;
        this.tilePos = tilePos;
    }

    public static void encode(MessageEntitySpawner message, FriendlyByteBuf buf) {
        buf.m_130085_(message.dimension.m_135782_());
        buf.writeInt(message.entityID);
        buf.writeInt(message.buttonID);
        buf.m_130064_(message.tilePos);
    }

    public static MessageEntitySpawner decode(FriendlyByteBuf buf) {
        return new MessageEntitySpawner(buf.m_130281_(), buf.readInt(), buf.readInt(), buf.m_130135_());
    }

    public static void handle(MessageEntitySpawner message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            TileEntityMGUSpawner spawner;
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            ServerLevel world = player.m_20194_().m_129880_(message.dimension);
            if (world != null && !world.f_46443_ && player.m_19879_() == message.entityID && (spawner = (TileEntityMGUSpawner)world.m_7702_(message.tilePos)) != null) {
                if (message.buttonID == 0) {
                    spawner.toggleRenderBox();
                }
                if (message.buttonID > 0 && message.buttonID <= 6) {
                    spawner.toggleOffset(message.buttonID);
                }
                BlockState state = world.m_8055_(message.tilePos);
                world.m_7260_(message.tilePos, state, state, 3);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

