/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.world.structure;

import com.aetherteam.aether.AetherTags;
import com.aetherteam.aether.world.structure.AetherStructureTypes;
import com.aetherteam.aether.world.structurepiece.GlowstoneRuinedPortalPiece;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class GlowstoneRuinedPortalStructure
extends Structure {
    private static final String[] STRUCTURE_LOCATION_PORTALS = new String[]{"ruined_portal/portal_1", "ruined_portal/portal_2", "ruined_portal/portal_3", "ruined_portal/portal_4", "ruined_portal/portal_5", "ruined_portal/portal_6", "ruined_portal/portal_7", "ruined_portal/portal_8", "ruined_portal/portal_9", "ruined_portal/portal_10"};
    private static final String[] STRUCTURE_LOCATION_GIANT_PORTALS = new String[]{"ruined_portal/giant_portal_1", "ruined_portal/giant_portal_2", "ruined_portal/giant_portal_3"};
    private final List<Setup> setups;
    public static final Codec<GlowstoneRuinedPortalStructure> CODEC = RecordCodecBuilder.create(codec -> codec.group((App)GlowstoneRuinedPortalStructure.m_226567_((RecordCodecBuilder.Instance)codec), (App)ExtraCodecs.m_144637_((Codec)Setup.CODEC.listOf()).fieldOf("setups").forGetter(structure -> structure.setups)).apply((Applicative)codec, GlowstoneRuinedPortalStructure::new));

    public GlowstoneRuinedPortalStructure(Structure.StructureSettings settings, List<Setup> setups) {
        super(settings);
        this.setups = setups;
    }

    public Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext context) {
        GlowstoneRuinedPortalPiece.Properties pieceProperties = new GlowstoneRuinedPortalPiece.Properties();
        WorldgenRandom worldGenRandom = context.f_226626_();
        ChunkPos chunkPos = context.f_226628_();
        ChunkGenerator chunkGenerator = context.f_226622_();
        LevelHeightAccessor levelHeightAccessor = context.f_226629_();
        RandomState randomState = context.f_226624_();
        BlockPos blockPosChunk = context.f_226628_().m_45615_();
        Setup portalSetup = null;
        if (this.setups.size() > 1) {
            float f = 0.0f;
            for (Setup setup : this.setups) {
                f += setup.weight();
            }
            float f1 = worldGenRandom.m_188501_();
            for (Setup setup2 : this.setups) {
                if (!((f1 -= setup2.weight() / f) < 0.0f)) continue;
                portalSetup = setup2;
                break;
            }
        } else {
            portalSetup = this.setups.get(0);
        }
        if (portalSetup == null) {
            throw new IllegalStateException();
        }
        Setup setup3 = portalSetup;
        pieceProperties.airPocket = GlowstoneRuinedPortalStructure.sample(worldGenRandom, setup3.airPocketProbability());
        pieceProperties.mossiness = setup3.mossiness();
        pieceProperties.overgrown = setup3.overgrown();
        pieceProperties.vines = setup3.vines();
        pieceProperties.replaceWithHolystone = setup3.replaceWithHolystone();
        ResourceLocation location = worldGenRandom.m_188501_() < 0.05f ? new ResourceLocation("aether", STRUCTURE_LOCATION_GIANT_PORTALS[worldGenRandom.m_188503_(STRUCTURE_LOCATION_GIANT_PORTALS.length)]) : new ResourceLocation("aether", STRUCTURE_LOCATION_PORTALS[worldGenRandom.m_188503_(STRUCTURE_LOCATION_PORTALS.length)]);
        StructureTemplate structureTemplate = context.f_226625_().m_230359_(location);
        Rotation rotation = (Rotation)Util.m_214670_((Object[])Rotation.values(), (RandomSource)worldGenRandom);
        Mirror mirror = worldGenRandom.m_188501_() < 0.5f ? Mirror.NONE : Mirror.FRONT_BACK;
        BlockPos blockPos = new BlockPos(structureTemplate.m_163801_().m_123341_() / 2, 0, structureTemplate.m_163801_().m_123343_() / 2);
        BoundingBox boundingbox = structureTemplate.m_74598_(blockPosChunk, rotation, blockPos, mirror);
        BlockPos centerPos = boundingbox.m_162394_();
        int i = chunkGenerator.m_214096_(centerPos.m_123341_(), centerPos.m_123343_(), GlowstoneRuinedPortalPiece.getHeightMapType(setup3.placement()), levelHeightAccessor, randomState) - 1;
        int j = GlowstoneRuinedPortalStructure.findSuitableY((RandomSource)worldGenRandom, chunkGenerator, setup3.placement(), i, boundingbox.m_71057_(), boundingbox, levelHeightAccessor, randomState);
        BlockPos spawnPos = new BlockPos(blockPosChunk.m_123341_(), j, blockPosChunk.m_123343_());
        if (GlowstoneRuinedPortalStructure.validCorners(chunkGenerator, levelHeightAccessor, chunkPos, randomState, spawnPos.m_123342_())) {
            return Optional.of(new Structure.GenerationStub(spawnPos, builder -> builder.m_142679_((StructurePiece)new GlowstoneRuinedPortalPiece(context.f_226625_(), spawnPos, setup3.placement(), pieceProperties, location, rotation, mirror, blockPos))));
        }
        return Optional.empty();
    }

    private static boolean sample(WorldgenRandom random, float threshold) {
        if (threshold == 0.0f) {
            return false;
        }
        if (threshold == 1.0f) {
            return true;
        }
        return random.m_188501_() < threshold;
    }

    private static int findSuitableY(RandomSource random, ChunkGenerator chunkGenerator, GlowstoneRuinedPortalPiece.VerticalPlacement verticalPlacement, int height, int blockCountY, BoundingBox box, LevelHeightAccessor heightAccessor, RandomState randomState) {
        int l;
        int j = heightAccessor.m_141937_() + 15;
        int i = verticalPlacement == GlowstoneRuinedPortalPiece.VerticalPlacement.PARTLY_BURIED ? height - blockCountY + Mth.m_216287_((RandomSource)random, (int)2, (int)8) : height;
        ImmutableList positions = ImmutableList.of((Object)new BlockPos(box.m_162395_(), 0, box.m_162398_()), (Object)new BlockPos(box.m_162399_(), 0, box.m_162398_()), (Object)new BlockPos(box.m_162395_(), 0, box.m_162401_()), (Object)new BlockPos(box.m_162399_(), 0, box.m_162401_()));
        List<NoiseColumn> noiseColumns = positions.stream().map(pos -> chunkGenerator.m_214184_(pos.m_123341_(), pos.m_123343_(), heightAccessor, randomState)).toList();
        Heightmap.Types heightmap$types = verticalPlacement == GlowstoneRuinedPortalPiece.VerticalPlacement.ON_OCEAN_FLOOR ? Heightmap.Types.OCEAN_FLOOR : Heightmap.Types.WORLD_SURFACE;
        for (l = i; l > j; --l) {
            int i1 = 0;
            for (NoiseColumn noiseColumn : noiseColumns) {
                BlockState blockState = noiseColumn.m_183556_(l);
                if (!heightmap$types.m_64299_().test(blockState) || ++i1 != 3) continue;
                return l;
            }
        }
        return l;
    }

    private static boolean validCorners(ChunkGenerator generator, LevelHeightAccessor heightAccessor, ChunkPos chunkPos, RandomState random, int spawnY) {
        NoiseColumn[] columns;
        int minX = chunkPos.m_45604_() - 1;
        int minZ = chunkPos.m_45605_() - 1;
        int maxX = chunkPos.m_45608_() + 1;
        int maxZ = chunkPos.m_45609_() + 1;
        for (NoiseColumn column : columns = new NoiseColumn[]{generator.m_214184_(minX, minZ, heightAccessor, random), generator.m_214184_(minX, maxZ, heightAccessor, random), generator.m_214184_(maxX, minZ, heightAccessor, random), generator.m_214184_(maxX, maxZ, heightAccessor, random)}) {
            if (column.m_183556_(spawnY).m_60795_() || column.m_183556_(spawnY).m_204336_(AetherTags.Blocks.NON_RUINED_PORTAL_SPAWNABLE)) continue;
            return true;
        }
        return false;
    }

    public StructureType<?> m_213658_() {
        return (StructureType)AetherStructureTypes.RUINED_PORTAL.get();
    }

    public record Setup(GlowstoneRuinedPortalPiece.VerticalPlacement placement, float airPocketProbability, float mossiness, boolean overgrown, boolean vines, boolean replaceWithHolystone, float weight) {
        public static final Codec<Setup> CODEC = RecordCodecBuilder.create(codec -> codec.group((App)GlowstoneRuinedPortalPiece.VerticalPlacement.CODEC.fieldOf("placement").forGetter(Setup::placement), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("air_pocket_probability").forGetter(Setup::airPocketProbability), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("mossiness").forGetter(Setup::mossiness), (App)Codec.BOOL.fieldOf("overgrown").forGetter(Setup::overgrown), (App)Codec.BOOL.fieldOf("vines").forGetter(Setup::vines), (App)Codec.BOOL.fieldOf("replace_with_holystone").forGetter(Setup::replaceWithHolystone), (App)ExtraCodecs.f_184349_.fieldOf("weight").forGetter(Setup::weight)).apply((Applicative)codec, Setup::new));
    }
}

