/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.item.accessories.gloves;

import com.aetherteam.aether.item.accessories.AccessoryItem;
import com.aetherteam.aether.item.accessories.gloves.LeatherGlovesItem;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import top.theillusivec4.curios.api.SlotContext;

public class GlovesItem
extends AccessoryItem {
    protected final ArmorMaterial material;
    protected final double damage;
    protected ResourceLocation GLOVES_TEXTURE;

    public GlovesItem(ArmorMaterial material, double punchDamage, String glovesName, Supplier<? extends SoundEvent> glovesSound, Item.Properties properties) {
        this(material, punchDamage, new ResourceLocation("aether", glovesName), glovesSound, properties);
    }

    public GlovesItem(ArmorMaterial material, double punchDamage, ResourceLocation glovesName, Supplier<? extends SoundEvent> glovesSound, Item.Properties properties) {
        super(glovesSound, properties);
        this.material = material;
        this.damage = punchDamage;
        this.setRenderTexture(glovesName.m_135827_(), glovesName.m_135815_());
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(SlotContext slotContext, UUID uuid, ItemStack stack) {
        HashMultimap attributes = HashMultimap.create();
        attributes.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(uuid, "Gloves Damage Bonus", this.damage, AttributeModifier.Operation.ADDITION));
        return attributes;
    }

    public int m_6473_() {
        return this.material.m_6646_();
    }

    public boolean m_6832_(ItemStack item, ItemStack material) {
        return this.material.m_6230_().test(material) || super.m_6832_(item, material);
    }

    public ArmorMaterial getMaterial() {
        return this.material;
    }

    public void setRenderTexture(String modId, String registryName) {
        this.GLOVES_TEXTURE = new ResourceLocation(modId, "textures/models/accessory/gloves/" + registryName + "_accessory.png");
    }

    public ResourceLocation getGlovesTexture() {
        return this.GLOVES_TEXTURE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ImmutableTriple<Float, Float, Float> getColors(ItemStack stack) {
        float red = 1.0f;
        float green = 1.0f;
        float blue = 1.0f;
        Item item = stack.m_41720_();
        if (item instanceof LeatherGlovesItem) {
            LeatherGlovesItem leatherGlovesItem = (LeatherGlovesItem)item;
            int i = leatherGlovesItem.m_41121_(stack);
            red = (float)(i >> 16 & 0xFF) / 255.0f;
            green = (float)(i >> 8 & 0xFF) / 255.0f;
            blue = (float)(i & 0xFF) / 255.0f;
        }
        return new ImmutableTriple((Object)Float.valueOf(red), (Object)Float.valueOf(green), (Object)Float.valueOf(blue));
    }
}

