/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.event.hooks;

import com.aetherteam.aether.capability.player.AetherPlayer;
import com.aetherteam.aether.capability.player.AetherPlayerCapability;
import com.aetherteam.aether.capability.time.AetherTime;
import com.aetherteam.aether.data.resources.registries.AetherDimensions;
import com.aetherteam.nitrogen.capability.INBTSynchable;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class CapabilityHooks {

    public static class AetherTimeHooks {
        public static void login(Player player) {
            AetherTimeHooks.syncAetherTime(player);
        }

        public static void changeDimension(Player player) {
            AetherTimeHooks.syncAetherTime(player);
        }

        public static void respawn(Player player) {
            AetherTimeHooks.syncAetherTime(player);
        }

        private static void syncAetherTime(Player player) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                if (player.m_9236_().m_6042_().f_63837_().equals((Object)AetherDimensions.AETHER_DIMENSION_TYPE.m_135782_())) {
                    AetherTime.get((Level)serverPlayer.m_9236_()).ifPresent(aetherTime -> aetherTime.updateEternalDay(serverPlayer));
                }
            }
        }
    }

    public static class AetherPlayerHooks {
        public static void login(Player player) {
            AetherPlayer.get(player).ifPresent(AetherPlayer::onLogin);
        }

        public static void logout(Player player) {
            AetherPlayer.get(player).ifPresent(AetherPlayer::onLogout);
        }

        public static void joinLevel(Entity entity) {
            if (entity instanceof Player) {
                Player player = (Player)entity;
                AetherPlayer.get(player).ifPresent(AetherPlayer::onJoinLevel);
            }
        }

        public static void update(LivingEntity entity) {
            if (entity instanceof Player) {
                Player player = (Player)entity;
                AetherPlayer.get(player).ifPresent(AetherPlayer::onUpdate);
            }
        }

        public static void clone(Player originalPlayer, Player newPlayer, boolean wasDeath) {
            originalPlayer.reviveCaps();
            AetherPlayer originalAetherPlayer = (AetherPlayer)AetherPlayer.get(originalPlayer).orElseThrow(() -> new IllegalStateException("Player " + originalPlayer.m_7755_().m_214077_() + " has no AetherPlayer capability!"));
            AetherPlayer newAetherPlayer = (AetherPlayer)AetherPlayer.get(newPlayer).orElseThrow(() -> new IllegalStateException("Player " + newPlayer.m_7755_().m_214077_() + " has no AetherPlayer capability!"));
            newAetherPlayer.copyFrom(originalAetherPlayer, wasDeath);
            originalPlayer.invalidateCaps();
        }

        public static void changeDimension(Player player) {
            if (!player.m_9236_().m_5776_()) {
                AetherPlayer.get(player).ifPresent(aetherPlayer -> {
                    if (aetherPlayer instanceof AetherPlayerCapability) {
                        AetherPlayerCapability capability = (AetherPlayerCapability)aetherPlayer;
                        capability.forceSync(INBTSynchable.Direction.CLIENT);
                    }
                });
            }
        }
    }
}

