/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.entity;

import com.aetherteam.aether.capability.player.AetherPlayer;
import com.aetherteam.aether.mixin.mixins.common.accessor.ServerGamePacketListenerImplAccessor;
import com.aetherteam.aether.network.AetherPacketHandler;
import com.aetherteam.aether.network.packet.serverbound.StepHeightPacket;
import com.aetherteam.nitrogen.network.PacketRelay;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.network.simple.SimpleChannel;

public interface MountableMob {
    public static final UUID MOUNT_HEIGHT_UUID = UUID.fromString("B2D5A57A-8DA5-4127-8091-14A4CCD000F1");
    public static final UUID DEFAULT_HEIGHT_UUID = UUID.fromString("31535561-F99D-4E14-ACE7-F636EAAD6180");
    public static final AttributeModifier STEP_HEIGHT_MODIFIER = new AttributeModifier(MOUNT_HEIGHT_UUID, "Mounted step height increase", 0.4, AttributeModifier.Operation.ADDITION);
    public static final AttributeModifier DEFAULT_STEP_HEIGHT_MODIFIER = new AttributeModifier(DEFAULT_HEIGHT_UUID, "Default step height increase", -0.1, AttributeModifier.Operation.ADDITION);

    default public void riderTick(Mob vehicle) {
        Entity entity = vehicle.m_6688_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            AetherPlayer.get(player).ifPresent(aetherPlayer -> {
                if (aetherPlayer.isJumping() && !this.isMountJumping()) {
                    this.setPlayerJumped(true);
                }
            });
        }
    }

    default public <T extends Mob> void tick(T vehicle) {
        if (vehicle.m_6084_()) {
            Entity entity = vehicle.m_6688_();
            if (vehicle.m_20160_() && entity instanceof LivingEntity) {
                LivingEntity passenger = (LivingEntity)entity;
                if (((MountableMob)vehicle).getPlayerJumped() && !((MountableMob)vehicle).isMountJumping() && ((MountableMob)vehicle).canJump()) {
                    ((MountableMob)vehicle).onJump(vehicle);
                    ((MountableMob)vehicle).setMountJumping(true);
                    ((MountableMob)vehicle).setPlayerJumped(false);
                }
                if (vehicle.m_20096_()) {
                    ((MountableMob)vehicle).setPlayerJumped(false);
                    ((MountableMob)vehicle).setMountJumping(false);
                }
                if (passenger instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)passenger;
                    ServerGamePacketListenerImplAccessor serverGamePacketListenerImplAccessor = (ServerGamePacketListenerImplAccessor)serverPlayer.f_8906_;
                    serverGamePacketListenerImplAccessor.aether$setAboveGroundTickCount(0);
                    serverGamePacketListenerImplAccessor.aether$setAboveGroundVehicleTickCount(0);
                }
            }
        }
    }

    default public <T extends Mob> void travel(T vehicle, Vec3 motion) {
        Entity entity = vehicle.m_6688_();
        if (vehicle.m_20160_() && entity instanceof LivingEntity) {
            AttributeInstance stepHeight;
            LivingEntity passenger = (LivingEntity)entity;
            vehicle.m_146922_(passenger.m_146908_() % 360.0f);
            vehicle.f_19859_ = vehicle.m_146908_();
            vehicle.m_146926_(passenger.m_146909_() * 0.5f % 360.0f);
            vehicle.m_5618_(vehicle.m_146908_());
            vehicle.m_5616_(vehicle.f_20883_);
            vehicle.f_20887_ = this.getFlyingSpeed();
            float f = passenger.f_20900_ * 0.5f;
            float f1 = passenger.f_20902_;
            if (f1 <= 0.0f) {
                f1 *= 0.25f;
            }
            if (((MountableMob)vehicle).getPlayerJumped() && !((MountableMob)vehicle).isMountJumping() && ((MountableMob)vehicle).canJump()) {
                MobEffectInstance jumpBoost;
                double jumpStrength = ((MountableMob)vehicle).getMountJumpStrength() * this.jumpFactor();
                vehicle.m_20334_(vehicle.m_20184_().m_7096_(), jumpStrength, vehicle.m_20184_().m_7094_());
                if (vehicle.m_21023_(MobEffects.f_19603_) && (jumpBoost = vehicle.m_21124_(MobEffects.f_19603_)) != null) {
                    vehicle.m_5997_(0.0, 0.1 * (double)(jumpBoost.m_19564_() + 1), 0.0);
                }
                vehicle.f_19812_ = true;
            }
            if ((stepHeight = vehicle.m_21051_((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get())) != null) {
                if (stepHeight.m_22109_(((MountableMob)vehicle).getDefaultStepHeightModifier())) {
                    stepHeight.m_22130_(((MountableMob)vehicle).getDefaultStepHeightModifier());
                }
                if (!stepHeight.m_22109_(((MountableMob)vehicle).getMountStepHeightModifier())) {
                    stepHeight.m_22118_(((MountableMob)vehicle).getMountStepHeightModifier());
                }
                if (vehicle.m_9236_().m_5776_()) {
                    PacketRelay.sendToServer((SimpleChannel)AetherPacketHandler.INSTANCE, (Object)new StepHeightPacket(vehicle.m_19879_()));
                }
            }
            if (vehicle.m_6109_()) {
                vehicle.m_7910_(((MountableMob)vehicle).getSteeringSpeed());
                this.travelWithInput(new Vec3((double)f, motion.f_82480_, (double)f1));
            } else if (passenger instanceof Player) {
                vehicle.m_20256_(Vec3.f_82478_);
            }
            vehicle.m_21043_(vehicle, false);
        } else {
            AttributeInstance stepHeight = vehicle.m_21051_((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get());
            if (stepHeight != null) {
                if (stepHeight.m_22109_(((MountableMob)vehicle).getMountStepHeightModifier())) {
                    stepHeight.m_22130_(((MountableMob)vehicle).getMountStepHeightModifier());
                }
                if (!stepHeight.m_22109_(((MountableMob)vehicle).getDefaultStepHeightModifier())) {
                    stepHeight.m_22118_(((MountableMob)vehicle).getDefaultStepHeightModifier());
                }
            }
            this.travelWithInput(motion);
        }
    }

    public void travelWithInput(Vec3 var1);

    public boolean getPlayerJumped();

    public void setPlayerJumped(boolean var1);

    public boolean canJump();

    public double getMountJumpStrength();

    public boolean isMountJumping();

    public void setMountJumping(boolean var1);

    public float getSteeringSpeed();

    public float getFlyingSpeed();

    public double jumpFactor();

    default public void onJump(Mob vehicle) {
        ForgeHooks.onLivingJump((LivingEntity)vehicle);
    }

    default public AttributeModifier getMountStepHeightModifier() {
        return STEP_HEIGHT_MODIFIER;
    }

    default public AttributeModifier getDefaultStepHeightModifier() {
        return DEFAULT_STEP_HEIGHT_MODIFIER;
    }
}

