/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.entity;

import com.aetherteam.aether.block.dungeon.DoorwayBlock;
import com.aetherteam.aether.client.AetherSoundEvents;
import com.aetherteam.aether.entity.EntityUtil;
import com.aetherteam.nitrogen.entity.BossMob;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.ForgeEventFactory;
import org.apache.commons.lang3.tuple.Pair;

public interface AetherBossMob<T extends Mob>
extends BossMob<T> {
    default public void closeRoom() {
        this.getDungeon().modifyRoom(state -> {
            if (state.m_60734_() instanceof DoorwayBlock) {
                return (BlockState)state.m_61124_((Property)DoorwayBlock.INVISIBLE, (Comparable)Boolean.valueOf(false));
            }
            return null;
        });
    }

    default public void openRoom() {
        this.getDungeon().modifyRoom(state -> {
            if (state.m_60734_() instanceof DoorwayBlock) {
                return (BlockState)state.m_61124_((Property)DoorwayBlock.INVISIBLE, (Comparable)Boolean.valueOf(true));
            }
            return null;
        });
    }

    default public void evaporate(T entity, BlockPos min, BlockPos max, Predicate<BlockState> check) {
        if (ForgeEventFactory.getMobGriefingEvent((Level)entity.m_9236_(), entity)) {
            for (BlockPos pos : BlockPos.m_121940_((BlockPos)min, (BlockPos)max)) {
                if (entity.m_9236_().m_8055_(pos).m_60734_() instanceof LiquidBlock && check.test(entity.m_9236_().m_8055_(pos))) {
                    entity.m_9236_().m_46597_(pos, Blocks.f_50016_.m_49966_());
                    this.evaporateEffects(entity, pos);
                    continue;
                }
                if (entity.m_9236_().m_6425_(pos).m_76178_() || !entity.m_9236_().m_8055_(pos).m_61138_((Property)BlockStateProperties.f_61362_) || !check.test(entity.m_9236_().m_6425_(pos).m_76188_())) continue;
                entity.m_9236_().m_46597_(pos, (BlockState)entity.m_9236_().m_8055_(pos).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)));
                this.evaporateEffects(entity, pos);
            }
        }
    }

    default public void evaporateEffects(T entity, BlockPos pos) {
        EntityUtil.spawnRemovalParticles(entity.m_9236_(), pos);
        entity.m_9236_().m_5594_(null, pos, (SoundEvent)AetherSoundEvents.WATER_EVAPORATE.get(), SoundSource.BLOCKS, 0.5f, 2.6f + (entity.m_9236_().m_213780_().m_188501_() - entity.m_9236_().m_213780_().m_188501_()) * 0.8f);
    }

    default public Pair<BlockPos, BlockPos> getDefaultBounds(T entity) {
        AABB boundingBox = entity.m_20191_();
        BlockPos min = new BlockPos(boundingBox.f_82288_ - 1.0, boundingBox.f_82289_ - 1.0, boundingBox.f_82290_ - 1.0);
        BlockPos max = new BlockPos(Math.ceil(boundingBox.f_82291_ - 1.0) + 1.0, Math.ceil(boundingBox.f_82292_ - 1.0) + 1.0, Math.ceil(boundingBox.f_82293_ - 1.0) + 1.0);
        return Pair.of((Object)min, (Object)max);
    }

    @Nullable
    public ResourceLocation getBossBarTexture();
}

