/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.client.gui.screen.perks;

import com.aetherteam.aether.api.AetherMoaTypes;
import com.aetherteam.aether.api.registers.MoaType;
import com.aetherteam.aether.capability.player.AetherPlayer;
import com.aetherteam.aether.client.gui.component.Builder;
import com.aetherteam.aether.client.gui.component.skins.ChangeSkinButton;
import com.aetherteam.aether.client.gui.component.skins.PatreonButton;
import com.aetherteam.aether.client.gui.component.skins.RefreshButton;
import com.aetherteam.aether.entity.AetherEntityTypes;
import com.aetherteam.aether.entity.passive.Moa;
import com.aetherteam.aether.network.AetherPacketHandler;
import com.aetherteam.aether.network.packet.serverbound.ServerMoaSkinPacket;
import com.aetherteam.aether.perk.CustomizationsOptions;
import com.aetherteam.aether.perk.data.ClientMoaSkinPerkData;
import com.aetherteam.aether.perk.types.MoaData;
import com.aetherteam.aether.perk.types.MoaSkins;
import com.aetherteam.nitrogen.api.users.User;
import com.aetherteam.nitrogen.api.users.UserData;
import com.aetherteam.nitrogen.network.NitrogenPacketHandler;
import com.aetherteam.nitrogen.network.PacketRelay;
import com.aetherteam.nitrogen.network.packet.serverbound.TriggerUpdateInfoPacket;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.simple.SimpleChannel;

public class MoaSkinsScreen
extends Screen {
    public static final ResourceLocation MOA_SKINS_GUI = new ResourceLocation("aether", "textures/gui/perks/skins/skins.png");
    private static final String PATREON_LINK = "https://www.patreon.com/TheAetherTeam";
    private static final String HELP_LINK = "https://github.com/The-Aether-Team/.github/wiki/Patreon-Guide";
    private final Screen lastScreen;
    private final int imageWidth = 176;
    private final int imageHeight = 184;
    private int leftPos;
    private int topPos;
    private final CustomizationsOptions customizations = CustomizationsOptions.INSTANCE;
    private List<MoaSkins.MoaSkin> moaSkins;
    private List<Float> snapPoints;
    private MoaSkins.MoaSkin selectedSkin;
    private ChangeSkinButton applyButton;
    private ChangeSkinButton removeButton;
    private boolean scrolling;
    private float scrollX;
    private float moaRotation = 0.0f;
    private Moa previewMoa;
    private boolean userConnectionExists = false;

    public MoaSkinsScreen(Screen lastScreen) {
        super((Component)Component.m_237115_((String)"gui.aether.moa_skins.title"));
        this.lastScreen = lastScreen;
    }

    public void m_7856_() {
        this.leftPos = (this.f_96543_ - this.imageWidth) / 2;
        this.topPos = (this.f_96544_ - this.imageHeight) / 2;
        User user = UserData.Client.getClientUser();
        this.userConnectionExists = user != null;
        this.moaSkins = List.copyOf(MoaSkins.getMoaSkins().values());
        this.snapPoints = new ArrayList<Float>();
        int remainingSlots = this.moaSkins.size() - this.maxSlots();
        for (int i = 0; i <= remainingSlots; ++i) {
            this.snapPoints.add(Float.valueOf(this.scrollbarGutterWidth() / (float)remainingSlots * (float)i));
        }
        if (this.getMinecraft().f_91074_ != null) {
            UUID uuid = this.getMinecraft().f_91074_.m_20148_();
            Map userSkinsData = ClientMoaSkinPerkData.INSTANCE.getClientPerkData();
            if (this.getSelectedSkin() == null) {
                this.selectedSkin = userSkinsData.containsKey(uuid) ? ((MoaData)userSkinsData.get(uuid)).moaSkin() : this.moaSkins.get(0);
            }
            this.applyButton = (ChangeSkinButton)this.m_142416_((GuiEventListener)new ChangeSkinButton(ChangeSkinButton.ButtonType.APPLY, new Builder((Component)Component.m_237115_((String)"gui.aether.moa_skins.button.apply"), pressed -> AetherPlayer.get((Player)this.getMinecraft().f_91074_).ifPresent(aetherPlayer -> {
                PacketRelay.sendToServer((SimpleChannel)AetherPacketHandler.INSTANCE, (Object)new ServerMoaSkinPacket.Apply(this.getMinecraft().f_91074_.m_20148_(), new MoaData(aetherPlayer.getLastRiddenMoa(), this.getSelectedSkin())));
                this.customizations.setMoaSkin(this.getSelectedSkin().getId());
                this.customizations.save();
                this.customizations.load();
            })).bounds(this.leftPos + this.imageWidth - 20, this.topPos + 13, 7, 7)));
            this.removeButton = (ChangeSkinButton)this.m_142416_((GuiEventListener)new ChangeSkinButton(ChangeSkinButton.ButtonType.REMOVE, new Builder((Component)Component.m_237115_((String)"gui.aether.moa_skins.button.remove"), pressed -> {
                PacketRelay.sendToServer((SimpleChannel)AetherPacketHandler.INSTANCE, (Object)new ServerMoaSkinPacket.Remove(this.getMinecraft().f_91074_.m_20148_()));
                this.customizations.setMoaSkin("");
                this.customizations.save();
                this.customizations.load();
            }).bounds(this.leftPos + this.imageWidth - 20, this.topPos + 22, 7, 7)));
            this.m_142416_((GuiEventListener)new RefreshButton(new Builder((Component)Component.m_237113_((String)""), pressed -> {
                if (RefreshButton.reboundTimer == 0) {
                    PacketRelay.sendToServer((SimpleChannel)NitrogenPacketHandler.INSTANCE, (Object)new TriggerUpdateInfoPacket(this.getMinecraft().f_91074_.m_19879_()));
                    RefreshButton.reboundTimer = 1200;
                }
            }).bounds(this.leftPos + 7, this.topPos + this.imageHeight - 25, 18, 18)));
            this.m_142416_((GuiEventListener)new PatreonButton(new Builder((Component)Component.m_237115_((String)"gui.aether.moa_skins.button.donate"), pressed -> this.getMinecraft().m_91152_((Screen)new ConfirmLinkScreen(callback -> {
                if (callback) {
                    Util.m_137581_().m_137646_(PATREON_LINK);
                }
                this.getMinecraft().m_91152_((Screen)this);
            }, PATREON_LINK, true))).bounds(this.leftPos + this.imageWidth / 2 - 27, this.topPos + this.imageHeight - 25, 54, 18)));
            this.m_142416_((GuiEventListener)new PatreonButton(new Builder((Component)Component.m_237115_((String)"?"), pressed -> this.getMinecraft().m_91152_((Screen)new ConfirmLinkScreen(callback -> {
                if (callback) {
                    Util.m_137581_().m_137646_(HELP_LINK);
                }
                this.getMinecraft().m_91152_((Screen)this);
            }, HELP_LINK, true))).bounds(this.leftPos + this.imageWidth / 2 + 63, this.topPos + this.imageHeight - 25, 18, 18), true));
        }
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(poseStack);
        this.renderWindow(poseStack);
        this.renderSlots(poseStack, mouseX, mouseY);
        this.renderInterface(poseStack, mouseX, mouseY, partialTicks);
        super.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        this.checkUserConnectionStatus();
    }

    private void renderWindow(PoseStack poseStack) {
        User user = UserData.Client.getClientUser();
        Font font = this.getMinecraft().f_91062_;
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)MOA_SKINS_GUI);
        this.m_93228_(poseStack, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        MutableComponent component = user == null ? Component.m_237115_((String)"gui.aether.moa_skins.text.donate") : Component.m_237115_((String)"gui.aether.moa_skins.text.reward");
        int y = this.topPos + this.imageHeight - 69 + font.m_239133_((FormattedText)component, this.imageWidth - 20);
        for (FormattedCharSequence sequence : font.m_92923_((FormattedText)component, this.imageWidth - 20)) {
            GuiComponent.m_168749_((PoseStack)poseStack, (Font)font, (FormattedCharSequence)sequence, (int)(this.leftPos + this.imageWidth / 2), (int)y, (int)0xFFFFFF);
            y += 12;
        }
    }

    private void renderSlots(PoseStack poseStack, int mouseX, int mouseY) {
        if (this.getMinecraft().f_91074_ != null) {
            UUID uuid = this.getMinecraft().f_91074_.m_20148_();
            Map userSkinsData = ClientMoaSkinPerkData.INSTANCE.getClientPerkData();
            User user = UserData.Client.getClientUser();
            List<MoaSkins.MoaSkin> visibleSkins = this.moaSkins.size() > this.maxSlots() ? this.moaSkins.subList(this.getSlotOffset(), this.getSlotOffset() + this.maxSlots()) : this.moaSkins;
            int slotIndex = 0;
            for (MoaSkins.MoaSkin skin : visibleSkins) {
                int x = this.leftPos + 7 + slotIndex * 18;
                int y = this.topPos + this.imageHeight / 2 + 9;
                if (user == null || !skin.getUserPredicate().test(user) || skin == this.getSelectedSkin() || this.getSlotIndex(mouseX, mouseY) == slotIndex) {
                    int u = skin == this.getSelectedSkin() || this.getSlotIndex(mouseX, mouseY) == slotIndex ? 18 : 0;
                    RenderSystem.m_157427_(GameRenderer::m_172817_);
                    RenderSystem.m_157456_((int)0, (ResourceLocation)MOA_SKINS_GUI);
                    this.m_93228_(poseStack, x, y, u, 191, 18, 18);
                }
                if (userSkinsData.containsKey(uuid) && ((MoaData)userSkinsData.get(uuid)).moaSkin() == skin) {
                    RenderSystem.m_157427_(GameRenderer::m_172817_);
                    RenderSystem.m_157456_((int)0, (ResourceLocation)MOA_SKINS_GUI);
                    this.m_93228_(poseStack, x, y, 36, 191, 18, 18);
                }
                RenderSystem.m_157427_(GameRenderer::m_172817_);
                RenderSystem.m_157456_((int)0, (ResourceLocation)skin.getIconLocation());
                GuiComponent.m_93133_((PoseStack)poseStack, (int)(x + 1), (int)(y + 1), (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
                ++slotIndex;
            }
        }
        this.renderScrollbar(poseStack);
        this.renderSlotTooltips(poseStack, mouseX, mouseY);
    }

    private void renderScrollbar(PoseStack poseStack) {
        int scrollbarTop = this.topPos + this.imageHeight / 2 + 29;
        int scrollbarLeft = this.leftPos + 8;
        int scrollbarU = this.moaSkins.size() > this.maxSlots() ? 0 : 13;
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)MOA_SKINS_GUI);
        this.m_93228_(poseStack, (int)((float)scrollbarLeft + this.scrollX), scrollbarTop, scrollbarU, 209, 13, 6);
    }

    private void renderSlotTooltips(PoseStack poseStack, double mouseX, double mouseY) {
        MoaSkins.MoaSkin skin = this.getSkinFromSlot(mouseX, mouseY);
        if (skin != null) {
            Component name = skin.getDisplayName();
            this.m_96602_(poseStack, name, (int)mouseX, (int)mouseY);
        }
    }

    private void renderInterface(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        User user = UserData.Client.getClientUser();
        if (user != null && this.getSelectedSkin().getUserPredicate().test(user)) {
            this.applyButton.f_93623_ = true;
            this.removeButton.f_93623_ = true;
            if (this.getSelectedSkin().getInfo().lifetime() || user.getCurrentTier() == null || user.getCurrentTierLevel() < this.getSelectedSkin().getInfo().tier().getLevel()) {
                boolean mouseOver = this.isMouseOverIcon(mouseX, mouseY, 8);
                this.renderLifetimeIcon(poseStack, mouseOver);
                if (mouseOver) {
                    this.renderTooltip(Component.m_237115_((String)"gui.aether.moa_skins.tooltip.title.access.lifetime"), (Component)Component.m_237115_((String)"gui.aether.moa_skins.tooltip.lifetime"), poseStack, mouseX, mouseY);
                }
            } else if (user.getCurrentTier() != null) {
                boolean mouseOver = this.isMouseOverIcon(mouseX, mouseY, 7);
                this.renderPledgingIcon(poseStack, mouseOver);
                if (mouseOver) {
                    this.renderTooltip(Component.m_237115_((String)"gui.aether.moa_skins.tooltip.title.access.pledging"), (Component)Component.m_237110_((String)"gui.aether.moa_skins.tooltip.pledging", (Object[])new Object[]{user.getCurrentTier().getDisplayName()}), poseStack, mouseX, mouseY);
                }
            }
        } else {
            this.applyButton.f_93623_ = false;
            this.removeButton.f_93623_ = false;
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157456_((int)0, (ResourceLocation)MOA_SKINS_GUI);
            this.m_93228_(poseStack, this.leftPos + 13, this.topPos + 13, 54, 191, 10, 14);
            if (this.getSelectedSkin().getInfo().lifetime()) {
                boolean mouseOver = this.isMouseOverIcon(mouseX, mouseY, 8);
                this.renderLifetimeIcon(poseStack, mouseOver);
                if (mouseOver) {
                    this.renderTooltip(Component.m_237115_((String)"gui.aether.moa_skins.tooltip.title.access.lifetime"), (Component)Component.m_237110_((String)"gui.aether.moa_skins.tooltip.access.lifetime", (Object[])new Object[]{this.getSelectedSkin().getInfo().tier().getDisplayName()}), poseStack, mouseX, mouseY);
                }
            } else {
                boolean mouseOver = this.isMouseOverIcon(mouseX, mouseY, 7);
                this.renderPledgingIcon(poseStack, mouseOver);
                if (mouseOver) {
                    this.renderTooltip(Component.m_237115_((String)"gui.aether.moa_skins.tooltip.title.access.pledging"), (Component)Component.m_237110_((String)"gui.aether.moa_skins.tooltip.access.pledging", (Object[])new Object[]{this.getSelectedSkin().getInfo().tier().getDisplayName()}), poseStack, mouseX, mouseY);
                }
            }
        }
        this.renderMoa(partialTicks);
        GuiComponent.m_93215_((PoseStack)poseStack, (Font)this.getMinecraft().f_91062_, (Component)this.getSelectedSkin().getDisplayName(), (int)(this.leftPos + this.imageWidth / 2), (int)(this.topPos + 12), (int)0xFFFFFF);
        GuiComponent.m_93215_((PoseStack)poseStack, (Font)this.getMinecraft().f_91062_, (Component)this.m_96636_(), (int)(this.leftPos + this.imageWidth / 2), (int)(this.topPos - 15), (int)0xFFFFFF);
    }

    private void renderLifetimeIcon(PoseStack poseStack, boolean mouseOver) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)MOA_SKINS_GUI);
        this.m_93228_(poseStack, this.leftPos + 13, this.topPos + this.imageHeight / 2 - 9, mouseOver ? 63 : 55, 184, 8, 7);
    }

    private void renderPledgingIcon(PoseStack poseStack, boolean mouseOver) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)MOA_SKINS_GUI);
        this.m_93228_(poseStack, this.leftPos + 13, this.topPos + this.imageHeight / 2 - 9, mouseOver ? 49 : 42, 184, 7, 7);
    }

    private boolean isMouseOverIcon(int mouseX, int mouseY, int width) {
        int leftPos = this.leftPos + 13;
        int topPos = this.topPos + this.imageHeight / 2 - 9;
        double mouseXDiff = mouseX - leftPos;
        double mouseYDiff = mouseY - topPos;
        return mouseYDiff <= 7.0 && mouseYDiff >= 0.0 && mouseXDiff <= (double)width && mouseXDiff >= 0.0;
    }

    private void renderTooltip(MutableComponent title, Component description, PoseStack poseStack, int mouseX, int mouseY) {
        ArrayList<MutableComponent> formattedTextList = new ArrayList<MutableComponent>();
        formattedTextList.add(title.m_130940_(ChatFormatting.GOLD));
        formattedTextList.addAll(this.getMinecraft().f_91062_.m_92865_().m_92414_((FormattedText)description, this.f_96543_ / 3, Style.f_131099_));
        this.renderComponentTooltip(poseStack, formattedTextList, mouseX, mouseY, this.getMinecraft().f_91062_);
    }

    private void renderMoa(float partialTicks) {
        if (this.getMinecraft().f_91073_ != null) {
            if (this.getPreviewMoa() == null) {
                Moa moa = (Moa)((EntityType)AetherEntityTypes.MOA.get()).m_20615_((Level)this.getMinecraft().f_91073_);
                if (moa != null) {
                    moa.generateMoaUUID();
                    moa.setMoaType((MoaType)AetherMoaTypes.BLUE.get());
                    moa.setSaddled(true);
                    this.previewMoa = moa;
                }
            } else {
                this.moaRotation = Mth.m_14177_((float)Mth.m_14179_((float)partialTicks, (float)this.moaRotation, (float)(this.moaRotation + 2.5f)));
                MoaSkinsScreen.renderRotatingEntity(this.leftPos + this.imageWidth / 2, this.topPos + this.imageHeight / 2 - 4, 27, this.moaRotation, -20.0f, (LivingEntity)this.getPreviewMoa());
            }
        }
    }

    public static void renderRotatingEntity(int posX, int posY, int scale, float angleXComponent, float angleYComponent, LivingEntity livingEntity) {
        PoseStack viewStack = RenderSystem.m_157191_();
        viewStack.m_85836_();
        viewStack.m_85837_((double)posX, (double)posY, 1050.0);
        viewStack.m_85841_(1.0f, 1.0f, -1.0f);
        RenderSystem.m_157182_();
        PoseStack poseStack = new PoseStack();
        poseStack.m_85837_(0.0, 0.0, 1000.0);
        poseStack.m_85841_((float)scale, (float)scale, (float)scale);
        Quaternion xQuaternion = Vector3f.f_122227_.m_122240_(180.0f);
        Quaternion zQuaternion = Vector3f.f_122223_.m_122240_(angleYComponent);
        xQuaternion.m_80148_(zQuaternion);
        poseStack.m_85845_(xQuaternion);
        float yBodyRot = livingEntity.f_20883_;
        float yRot = livingEntity.m_146908_();
        float xRot = livingEntity.m_146909_();
        livingEntity.m_5618_(180.0f + angleXComponent);
        livingEntity.m_146922_(180.0f + angleXComponent);
        livingEntity.m_146926_(-angleYComponent);
        livingEntity.m_5616_(livingEntity.m_146908_());
        livingEntity.f_20886_ = livingEntity.m_146908_();
        Lighting.m_166384_();
        EntityRenderDispatcher entityRenderDispatcher = Minecraft.m_91087_().m_91290_();
        zQuaternion.m_80157_();
        entityRenderDispatcher.m_114412_(zQuaternion);
        entityRenderDispatcher.m_114468_(false);
        MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
        RenderSystem.m_69890_(() -> entityRenderDispatcher.m_114384_((Entity)livingEntity, 0.0, 0.0, 0.0, 0.0f, 1.0f, poseStack, (MultiBufferSource)bufferSource, 0xF000F0));
        bufferSource.m_109911_();
        entityRenderDispatcher.m_114468_(true);
        livingEntity.m_5618_(yBodyRot);
        livingEntity.m_146922_(yRot);
        livingEntity.m_146926_(xRot);
        viewStack.m_85849_();
        RenderSystem.m_157182_();
        Lighting.m_84931_();
    }

    private void checkUserConnectionStatus() {
        User user = UserData.Client.getClientUser();
        if (this.getMinecraft().f_91074_ != null) {
            if (user == null && this.userConnectionExists) {
                PacketRelay.sendToServer((SimpleChannel)AetherPacketHandler.INSTANCE, (Object)new ServerMoaSkinPacket.Remove(this.getMinecraft().f_91074_.m_20148_()));
                this.userConnectionExists = false;
            } else if (user != null && !this.userConnectionExists && MoaSkins.getMoaSkins().get(this.customizations.getMoaSkin()) != null) {
                AetherPlayer.get((Player)this.getMinecraft().f_91074_).ifPresent(aetherPlayer -> PacketRelay.sendToServer((SimpleChannel)AetherPacketHandler.INSTANCE, (Object)new ServerMoaSkinPacket.Apply(this.getMinecraft().f_91074_.m_20148_(), new MoaData(aetherPlayer.getLastRiddenMoa(), MoaSkins.getMoaSkins().get(this.customizations.getMoaSkin())))));
                this.userConnectionExists = true;
            }
        }
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (button == 0) {
            float scrollbarGutterLeft = (float)this.leftPos + 7.0f;
            float f = this.topPos;
            Objects.requireNonNull(this);
            float scrollbarGutterTop = f + 184.0f / 2.0f + 29.0f;
            double mouseXDiff = mouseX - (double)scrollbarGutterLeft;
            double mouseYDiff = mouseY - (double)scrollbarGutterTop;
            if ((mouseYDiff <= 6.0 && mouseYDiff >= 0.0 || this.scrolling) && mouseXDiff <= 160.0 && mouseXDiff >= 0.0) {
                this.scrolling = true;
                this.scrollX = Math.max(0.0f, Math.min((float)mouseXDiff - this.scrollbarWidth() / 2.0f, this.scrollbarGutterWidth()));
                return true;
            }
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        int i = 0;
        int index = this.getSlotOffset();
        if (index != -1) {
            i = index;
        }
        if (delta < 0.0) {
            i = Math.min(i + 1, this.snapPoints.size() - 1);
        } else if (delta > 0.0) {
            i = Math.max(i - 1, 0);
        }
        this.scrollX = this.snapPoints.get(i).floatValue();
        return true;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        MoaSkins.MoaSkin skin = this.getSkinFromSlot(mouseX, mouseY);
        if (skin != null) {
            this.selectedSkin = skin;
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    @Nullable
    private MoaSkins.MoaSkin getSkinFromSlot(double mouseX, double mouseY) {
        int slot = this.getSlotIndex(mouseX, mouseY);
        if (slot != -1) {
            int trueSlot = slot + this.getSlotOffset();
            return this.moaSkins.get(trueSlot);
        }
        return null;
    }

    private int getSlotIndex(double mouseX, double mouseY) {
        int slotLeft = this.leftPos + 7;
        int slotTop = this.topPos + this.imageHeight / 2 + 9;
        double mouseXDiff = mouseX - (double)slotLeft;
        double mouseYDiff = mouseY - (double)slotTop;
        return mouseYDiff <= 18.0 && mouseYDiff >= 0.0 && mouseXDiff <= 160.0 && mouseXDiff >= 0.0 ? (int)(mouseXDiff / 18.0) : -1;
    }

    private int getSlotOffset() {
        int offset = 0;
        int index = this.snapPoints.indexOf(Float.valueOf(this.scrollX));
        if (index != -1) {
            offset = index;
        } else {
            for (int i = 0; i < this.snapPoints.size() - 1; ++i) {
                float nextPoint;
                float currentPoint = this.snapPoints.get(i).floatValue();
                float midway = currentPoint + ((nextPoint = this.snapPoints.get(i + 1).floatValue()) - currentPoint) / 2.0f;
                if (this.scrollX > midway && this.scrollX < nextPoint) {
                    offset = i + 1;
                    continue;
                }
                if (!(this.scrollX <= midway) || !(this.scrollX > currentPoint)) continue;
                offset = i;
            }
        }
        return offset;
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        this.scrolling = false;
        return super.m_6348_(mouseX, mouseY, button);
    }

    private float scrollbarWidth() {
        return 13.0f;
    }

    private float scrollbarGutterWidth() {
        return 160.0f - this.scrollbarWidth();
    }

    private int maxSlots() {
        return 9;
    }

    public void m_7379_() {
        this.getMinecraft().m_91152_(this.lastScreen);
    }

    public boolean m_7043_() {
        return false;
    }

    public MoaSkins.MoaSkin getSelectedSkin() {
        return this.selectedSkin;
    }

    public Moa getPreviewMoa() {
        return this.previewMoa;
    }
}

