/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.monitor;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.shared.computer.terminal.TerminalState;
import dan200.computercraft.shared.network.NetworkHandler;
import dan200.computercraft.shared.network.client.MonitorClientMessage;
import dan200.computercraft.shared.peripheral.monitor.ServerMonitor;
import dan200.computercraft.shared.peripheral.monitor.TileMonitor;
import java.util.ArrayDeque;
import java.util.Queue;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.level.ChunkWatchEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="computercraft")
public final class MonitorWatcher {
    private static final Queue<TileMonitor> watching = new ArrayDeque<TileMonitor>();

    private MonitorWatcher() {
    }

    static void enqueue(TileMonitor monitor) {
        if (monitor.enqueued) {
            return;
        }
        monitor.enqueued = true;
        monitor.cached = null;
        watching.add(monitor);
    }

    @SubscribeEvent
    public static void onWatch(ChunkWatchEvent.Watch event) {
        for (BlockEntity te : event.getChunk().m_62954_().values()) {
            TileMonitor monitor;
            ServerMonitor serverMonitor;
            if (!(te instanceof TileMonitor) || (serverMonitor = MonitorWatcher.getMonitor(monitor = (TileMonitor)te)) == null || monitor.enqueued) continue;
            TerminalState state = MonitorWatcher.getState(monitor, serverMonitor);
            NetworkHandler.sendToPlayer(event.getPlayer(), new MonitorClientMessage(monitor.m_58899_(), state));
        }
    }

    @SubscribeEvent
    public static void onTick(TickEvent.ServerTickEvent event) {
        TileMonitor tile;
        boolean obeyLimit;
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        long limit = ComputerCraft.monitorBandwidth;
        boolean bl = obeyLimit = limit > 0L;
        while (!(obeyLimit && limit <= 0L || (tile = watching.poll()) == null)) {
            LevelChunk chunk;
            tile.enqueued = false;
            ServerMonitor monitor = MonitorWatcher.getMonitor(tile);
            if (monitor == null) continue;
            BlockPos pos = tile.m_58899_();
            Level world = tile.m_58904_();
            if (!(world instanceof ServerLevel) || ((ServerLevel)world).m_7726_().f_8325_.m_183262_((chunk = world.m_46745_(pos)).m_7697_(), false).isEmpty()) continue;
            TerminalState state = MonitorWatcher.getState(tile, monitor);
            NetworkHandler.sendToAllTracking(new MonitorClientMessage(pos, state), chunk);
            limit -= (long)state.size();
        }
    }

    private static ServerMonitor getMonitor(TileMonitor monitor) {
        return !monitor.m_58901_() && monitor.getXIndex() == 0 && monitor.getYIndex() == 0 ? monitor.getCachedServerMonitor() : null;
    }

    private static TerminalState getState(TileMonitor tile, ServerMonitor monitor) {
        TerminalState state = tile.cached;
        if (state == null) {
            state = tile.cached = new TerminalState(monitor.getTerminal());
        }
        return state;
    }
}

