/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.computer.recipe;

import com.google.gson.JsonObject;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.recipe.ComputerConvertRecipe;
import dan200.computercraft.shared.util.RecipeUtil;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;

public abstract class ComputerFamilyRecipe
extends ComputerConvertRecipe {
    private final ComputerFamily family;

    public ComputerFamilyRecipe(ResourceLocation identifier, String group, int width, int height, NonNullList<Ingredient> ingredients, ItemStack result, ComputerFamily family) {
        super(identifier, group, width, height, ingredients, result);
        this.family = family;
    }

    public ComputerFamily getFamily() {
        return this.family;
    }

    public static abstract class Serializer<T extends ComputerFamilyRecipe>
    implements RecipeSerializer<T> {
        protected abstract T create(ResourceLocation var1, String var2, int var3, int var4, NonNullList<Ingredient> var5, ItemStack var6, ComputerFamily var7);

        @Nonnull
        public T fromJson(@Nonnull ResourceLocation identifier, @Nonnull JsonObject json) {
            String group = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
            ComputerFamily family = RecipeUtil.getFamily(json, "family");
            RecipeUtil.ShapedTemplate template = RecipeUtil.getTemplate(json);
            ItemStack result = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            return this.create(identifier, group, template.width(), template.height(), template.ingredients(), result, family);
        }

        @Nonnull
        public T fromNetwork(@Nonnull ResourceLocation identifier, @Nonnull FriendlyByteBuf buf) {
            int width = buf.m_130242_();
            int height = buf.m_130242_();
            String group = buf.m_130136_(Short.MAX_VALUE);
            NonNullList ingredients = NonNullList.m_122780_((int)(width * height), (Object)Ingredient.f_43901_);
            for (int i = 0; i < ingredients.size(); ++i) {
                ingredients.set(i, (Object)Ingredient.m_43940_((FriendlyByteBuf)buf));
            }
            ItemStack result = buf.m_130267_();
            ComputerFamily family = (ComputerFamily)buf.m_130066_(ComputerFamily.class);
            return this.create(identifier, group, width, height, (NonNullList<Ingredient>)ingredients, result, family);
        }

        public void toNetwork(@Nonnull FriendlyByteBuf buf, @Nonnull T recipe) {
            buf.m_130130_(recipe.m_44220_());
            buf.m_130130_(recipe.m_44221_());
            buf.m_130070_(((ComputerConvertRecipe)((Object)recipe)).m_6076_());
            for (Ingredient ingredient : recipe.m_7527_()) {
                ingredient.m_43923_(buf);
            }
            buf.m_130055_(recipe.m_8043_());
            buf.m_130068_((Enum)((ComputerFamilyRecipe)((Object)recipe)).getFamily());
        }
    }
}

