/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.computer.core;

import com.google.common.annotations.VisibleForTesting;
import dan200.computercraft.ComputerCraft;
import dan200.computercraft.ComputerCraftAPIImpl;
import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.filesystem.IMount;
import dan200.computercraft.core.ComputerContext;
import dan200.computercraft.core.computer.ComputerThread;
import dan200.computercraft.core.computer.GlobalEnvironment;
import dan200.computercraft.core.computer.mainthread.MainThread;
import dan200.computercraft.core.lua.CobaltLuaMachine;
import dan200.computercraft.core.lua.ILuaMachine;
import dan200.computercraft.shared.computer.core.ServerComputerRegistry;
import dan200.computercraft.shared.computer.metrics.GlobalMetrics;
import dan200.computercraft.shared.util.IDAssigner;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraftforge.versions.mcp.MCPVersion;

public final class ServerContext {
    private static final LevelResource FOLDER = new LevelResource("computercraft");
    @VisibleForTesting
    public static ILuaMachine.Factory luaMachine = CobaltLuaMachine::new;
    @Nullable
    private static ServerContext instance;
    private final MinecraftServer server;
    private final ServerComputerRegistry registry = new ServerComputerRegistry();
    private final GlobalMetrics metrics = new GlobalMetrics();
    private final ComputerContext context;
    private final MainThread mainThread;
    private final IDAssigner idAssigner;
    private final Path storageDir;

    private ServerContext(MinecraftServer server) {
        this.server = server;
        this.storageDir = server.m_129843_(FOLDER);
        this.mainThread = new MainThread();
        this.context = new ComputerContext(new Environment(server), new ComputerThread(ComputerCraft.computerThreads), this.mainThread, luaMachine);
        this.idAssigner = new IDAssigner(this.storageDir.resolve("ids.json"));
    }

    public static void create(MinecraftServer server) {
        if (instance != null) {
            throw new IllegalStateException("ServerContext already exists!");
        }
        instance = new ServerContext(server);
    }

    public static void close() {
        ServerContext instance = ServerContext.instance;
        if (instance == null) {
            return;
        }
        instance.registry.close();
        try {
            if (!instance.context.close(1L, TimeUnit.SECONDS)) {
                ComputerCraft.log.error("Failed to stop computers under deadline.");
            }
        }
        catch (InterruptedException e) {
            ComputerCraft.log.error("Failed to stop computers.", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        ServerContext.instance = null;
    }

    public static ServerContext get(MinecraftServer server) {
        Objects.requireNonNull(server, "Server cannot be null");
        ServerContext instance = ServerContext.instance;
        if (instance == null) {
            throw new IllegalStateException("ServerContext has not been started yet");
        }
        if (instance.server != server) {
            throw new IllegalStateException("Incorrect server given. Did ServerContext shutdown correctly?");
        }
        return instance;
    }

    ComputerContext computerContext() {
        return this.context;
    }

    public void tick() {
        this.registry.update();
        this.mainThread.tick();
    }

    public ServerComputerRegistry registry() {
        return this.registry;
    }

    public int getNextId(String kind) {
        return this.idAssigner.getNextId(kind);
    }

    public Path storageDir() {
        return this.storageDir;
    }

    public GlobalMetrics metrics() {
        return this.metrics;
    }

    private record Environment(MinecraftServer server) implements GlobalEnvironment
    {
        @Override
        public IMount createResourceMount(String domain, String subPath) {
            return ComputerCraftAPI.createResourceMount(domain, subPath);
        }

        @Override
        public InputStream createResourceFile(String domain, String subPath) {
            return ComputerCraftAPIImpl.getResourceFile(this.server, domain, subPath);
        }

        @Override
        @Nonnull
        public String getHostString() {
            return String.format("ComputerCraft %s (Minecraft %s)", ComputerCraftAPI.getInstalledVersion(), MCPVersion.getMCVersion());
        }

        @Override
        @Nonnull
        public String getUserAgent() {
            return "computercraft/" + ComputerCraftAPI.getInstalledVersion();
        }
    }
}

