/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.world.structure;

import corgitaco.corgilib.world.level.feature.gen.TreeFromStructureNBTFeature;
import java.util.HashSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.SimpleStateProvider;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import potionstudios.byg.common.block.BYGWoodTypes;
import potionstudios.byg.common.world.structure.BYGStructurePieceTypes;
import potionstudios.byg.mixin.access.StructureTemplateAccess;

public class AncientTreePiece
extends StructurePiece {
    private final StructureTemplate structureTemplate;
    private final ResourceLocation structureId;
    private final BlockPos placePos;

    protected AncientTreePiece(StructureTemplate template, ResourceLocation structureId, BlockPos placePos, BoundingBox bb) {
        super(BYGStructurePieceTypes.ANCIENT_TREE_PIECE.get(), 0, bb);
        this.structureTemplate = template;
        this.structureId = structureId;
        this.placePos = placePos;
    }

    public AncientTreePiece(StructurePieceSerializationContext context, CompoundTag tag) {
        super(BYGStructurePieceTypes.ANCIENT_TREE_PIECE.get(), tag);
        this.placePos = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("place_pos"));
        this.structureId = new ResourceLocation(tag.m_128461_("structure_id"));
        this.structureTemplate = (StructureTemplate)context.f_226956_().m_230407_(this.structureId).orElseThrow();
    }

    protected void m_183620_(StructurePieceSerializationContext structurePieceSerializationContext, CompoundTag compoundTag) {
        compoundTag.m_128365_("place_pos", (Tag)NbtUtils.m_129224_((BlockPos)this.placePos));
        compoundTag.m_128359_("structure_id", this.structureId.toString());
    }

    public void m_213694_(WorldGenLevel worldGenLevel, StructureManager structureManager, ChunkGenerator chunkGenerator, RandomSource randomSource, BoundingBox boundingBox, ChunkPos chunkPos, BlockPos blockPos) {
        StructurePlaceSettings placeSettings = new StructurePlaceSettings().m_74379_(Rotation.m_221990_((RandomSource)randomSource));
        List<StructureTemplate.Palette> basePalettes = ((StructureTemplateAccess)this.structureTemplate).byg_getPalettes();
        Vec3i size = this.structureTemplate.m_163801_();
        BlockPos localOffset = new BlockPos(-size.m_123341_() / 2, 0, -size.m_123343_() / 2);
        BlockPos offsettedPlacePos = this.placePos.m_121955_((Vec3i)localOffset);
        this.structureTemplate.m_74633_(placeSettings, offsettedPlacePos);
        StructureTemplate.Palette randomPalette = placeSettings.m_74387_(basePalettes, offsettedPlacePos);
        TreeFromStructureNBTFeature.fillLogsUnder((RandomSource)randomSource, (BlockStateProvider)SimpleStateProvider.m_191384_((BlockState)BYGWoodTypes.REDWOOD.log().defaultBlockState()), (WorldGenLevel)worldGenLevel, (BlockPos)this.placePos, (StructurePlaceSettings)placeSettings, (BlockPos)localOffset, (List)randomPalette.m_74653_(Blocks.f_50108_), (int)200, (BlockPredicate)BlockPredicate.m_204677_((TagKey)BlockTags.f_144274_));
        HashSet trunkPositions = new HashSet();
        TreeFromStructureNBTFeature.placeLogsWithRotation((BlockStateProvider)SimpleStateProvider.m_191384_((BlockState)BYGWoodTypes.REDWOOD.log().defaultBlockState()), (WorldGenLevel)worldGenLevel, (BlockPos)this.placePos, (RandomSource)randomSource, (StructurePlaceSettings)placeSettings, (BlockPos)localOffset, (List)randomPalette.m_74653_((Block)BYGWoodTypes.REDWOOD.log().get()), trunkPositions);
        HashSet leavePositions = new HashSet();
        TreeFromStructureNBTFeature.placeLeavesWithCalculatedDistanceAndRotation((BlockStateProvider)SimpleStateProvider.m_191384_((BlockState)BYGWoodTypes.REDWOOD.leaves().defaultBlockState()), (WorldGenLevel)worldGenLevel, (BlockPos)this.placePos, (RandomSource)randomSource, (StructurePlaceSettings)placeSettings, (List)randomPalette.m_74653_((Block)BYGWoodTypes.REDWOOD.leaves().get()), leavePositions, (BlockPos)localOffset, (BlockPredicate)BlockPredicate.m_190419_());
        TreeFromStructureNBTFeature.placeTreeDecorations(List.of(), (WorldGenLevel)worldGenLevel, (RandomSource)randomSource, leavePositions, trunkPositions);
        this.f_73383_ = this.structureTemplate.m_74633_(placeSettings, this.placePos.m_121955_((Vec3i)localOffset));
    }
}

