/*
 * Decompiled with CFR 0.152.
 */
package potionstudios.byg.common.world.feature.config;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.SimpleStateProvider;

public class HangingColumnConfig
implements FeatureConfiguration {
    public static final Codec<HangingColumnConfig> CODEC = RecordCodecBuilder.create(codecRecorder -> codecRecorder.group((App)BlockStateProvider.f_68747_.fieldOf("block_provider").forGetter(config -> config.blockProvider), (App)Codec.INT.fieldOf("min_length").forGetter(config -> config.minLength), (App)Codec.INT.fieldOf("max_length").forGetter(config -> config.maxLength), (App)BlockState.f_61039_.listOf().fieldOf("whitelist").forGetter(config -> config.whitelist.stream().map(Block::m_49966_).collect(Collectors.toList()))).apply((Applicative)codecRecorder, HangingColumnConfig::new));
    private final BlockStateProvider blockProvider;
    private final int minLength;
    private final int maxLength;
    private final Set<Block> whitelist;

    HangingColumnConfig(BlockStateProvider blockProvider, int minLength, int maxLength, List<BlockState> whitelist) {
        this.blockProvider = blockProvider;
        this.minLength = minLength;
        this.maxLength = maxLength;
        this.whitelist = whitelist.stream().map(BlockBehaviour.BlockStateBase::m_60734_).collect(Collectors.toSet());
    }

    public BlockStateProvider getBlockProvider() {
        return this.blockProvider;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public int getMinLength() {
        return this.minLength;
    }

    public int getMaxPossibleLength() {
        int returnValue = this.minLength - this.maxLength;
        if (returnValue <= 0) {
            returnValue = 1;
        }
        return returnValue;
    }

    public Set<Block> getWhitelist() {
        return this.whitelist;
    }

    public static class Builder {
        private BlockStateProvider blockProvider = SimpleStateProvider.m_191384_((BlockState)Blocks.f_50050_.m_49966_());
        private List<Block> whitelist = ImmutableList.of((Object)Blocks.f_50440_);
        private int minLength = 1;
        private int maxLength = 9;

        public Builder setBlock(Block block) {
            this.blockProvider = block != null ? SimpleStateProvider.m_191384_((BlockState)block.m_49966_()) : SimpleStateProvider.m_191384_((BlockState)Blocks.f_50069_.m_49966_());
            return this;
        }

        public Builder setBlock(BlockState state) {
            this.blockProvider = state != null ? SimpleStateProvider.m_191384_((BlockState)state) : SimpleStateProvider.m_191384_((BlockState)Blocks.f_50069_.m_49966_());
            return this;
        }

        public Builder setBlock(BlockStateProvider provider) {
            this.blockProvider = provider != null ? provider : SimpleStateProvider.m_191384_((BlockState)Blocks.f_50069_.m_49966_());
            return this;
        }

        public Builder setMinLength(int minLength) {
            this.minLength = minLength;
            return this;
        }

        public Builder setMaxLength(int maxPossibleHeight) {
            this.maxLength = maxPossibleHeight != 0 ? maxPossibleHeight + 1 : 1;
            return this;
        }

        public Builder setWhitelist(ImmutableList<Block> whitelist) {
            this.whitelist = whitelist;
            return this;
        }

        public Builder copy(HangingColumnConfig config) {
            this.blockProvider = config.blockProvider;
            this.minLength = config.minLength;
            this.maxLength = config.maxLength;
            this.whitelist = ImmutableList.copyOf(config.whitelist);
            return this;
        }

        public HangingColumnConfig build() {
            return new HangingColumnConfig(this.blockProvider, this.minLength, this.maxLength, this.whitelist.stream().map(Block::m_49966_).collect(Collectors.toList()));
        }
    }
}

