/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.tainted.save;

import com.direwolf20.buildinggadgets.common.util.helpers.NBTHelper;
import it.unimi.dsi.fastutil.longs.Long2ObjectRBTreeMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectSortedMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.saveddata.SavedData;

public abstract class TimedDataSave<T extends TimedValue>
extends SavedData {
    private Map<UUID, T> idToValue = new HashMap<UUID, T>();
    private Long2ObjectSortedMap<Set<UUID>> timeToId = new Long2ObjectRBTreeMap();

    public UUID getFreeUUID() {
        UUID res = UUID.randomUUID();
        return this.idToValue.containsKey(res) ? this.getFreeUUID() : res;
    }

    protected void writeAllIds(FriendlyByteBuf buffer) {
        for (UUID id : this.idToValue.keySet()) {
            buffer.m_130077_(id);
        }
    }

    protected T get(UUID id) {
        return (T)this.get(id, uuid -> this.createValue());
    }

    protected T get(UUID id, Function<UUID, T> factory) {
        this.m_77762_();
        return (T)((TimedValue)this.idToValue.computeIfAbsent(id, factory));
    }

    protected void remove(UUID id) {
        Set set;
        TimedValue val = (TimedValue)this.idToValue.remove(id);
        if (val != null && !(set = (Set)this.timeToId.get(val.getUpdateTime())).isEmpty()) {
            set.remove(id);
            if (set.isEmpty()) {
                this.timeToId.remove(val.getUpdateTime());
            }
        }
    }

    protected boolean contains(UUID id) {
        return this.idToValue.containsKey(id);
    }

    public long getLastUpdateTime(UUID id) {
        return ((TimedValue)this.get(id)).getUpdateTime();
    }

    public void load(CompoundTag nbt) {
        Tag timeList = nbt.m_128423_("data_map");
        this.timeToId.clear();
        this.idToValue.clear();
        if (timeList instanceof ListTag) {
            NBTHelper.deserializeUUIDMap((ListTag)timeList, this.idToValue, inbt -> this.readValue((CompoundTag)inbt));
            for (Map.Entry<UUID, T> entry : this.idToValue.entrySet()) {
                ((Set)this.timeToId.computeIfAbsent(((TimedValue)entry.getValue()).getUpdateTime(), i -> new HashSet())).add(entry.getKey());
            }
        }
    }

    public CompoundTag m_7176_(CompoundTag compound) {
        ListTag data = NBTHelper.serializeUUIDMap(this.idToValue, TimedValue::write);
        compound.m_128365_("data_map", (Tag)data);
        return compound;
    }

    protected abstract T createValue();

    protected abstract T readValue(CompoundTag var1);

    public static class TimedValue {
        private long lastUpdateTime;

        protected TimedValue(CompoundTag nbt) {
            this(nbt.m_128425_("time", 4) ? nbt.m_128454_("time") : System.currentTimeMillis());
        }

        protected TimedValue(long lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
        }

        protected TimedValue() {
            this(System.currentTimeMillis());
        }

        public TimedValue updateTime() {
            this.lastUpdateTime = System.currentTimeMillis();
            return this;
        }

        public long getUpdateTime() {
            return this.lastUpdateTime;
        }

        public CompoundTag write() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128356_("time", this.lastUpdateTime);
            return nbt;
        }
    }
}

