/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.network.split;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraft.network.FriendlyByteBuf;

public final class SplitPacket {
    private final int id;
    private final int index;
    private final short sessionId;
    private final boolean hasMore;
    private final FriendlyByteBuf payload;

    static SplitPacket readFrom(FriendlyByteBuf buffer) {
        int id = buffer.m_130242_();
        int index = buffer.m_130242_();
        short sessionId = buffer.readShort();
        boolean hasMore = buffer.readBoolean();
        FriendlyByteBuf payload = new FriendlyByteBuf(Unpooled.buffer((int)buffer.readableBytes(), (int)Integer.MAX_VALUE));
        buffer.readBytes((ByteBuf)payload);
        return new SplitPacket(id, index, sessionId, hasMore, payload);
    }

    SplitPacket(int id, int index, short sessionId, boolean hasMore, FriendlyByteBuf payload) {
        this.id = id;
        this.index = index;
        this.sessionId = sessionId;
        this.hasMore = hasMore;
        this.payload = payload;
    }

    void writeTo(FriendlyByteBuf buffer) {
        buffer.m_130130_(this.id);
        buffer.m_130130_(this.index);
        buffer.writeShort((int)this.sessionId);
        buffer.writeBoolean(this.hasMore);
        buffer.writeBytes((ByteBuf)this.payload);
    }

    public int getId() {
        return this.id;
    }

    public int getIndex() {
        return this.index;
    }

    public short getSessionId() {
        return this.sessionId;
    }

    public boolean hasMore() {
        return this.hasMore;
    }

    public FriendlyByteBuf getPayload() {
        return this.payload;
    }
}

