/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.network.packets;

import com.direwolf20.buildinggadgets.common.items.AbstractGadget;
import com.direwolf20.buildinggadgets.common.items.GadgetBuilding;
import com.direwolf20.buildinggadgets.common.items.GadgetCopyPaste;
import com.direwolf20.buildinggadgets.common.items.GadgetExchanger;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class PacketToggleMode {
    private final int mode;

    public static void encode(PacketToggleMode msg, FriendlyByteBuf buffer) {
        buffer.writeInt(msg.mode);
    }

    public static PacketToggleMode decode(FriendlyByteBuf buffer) {
        return new PacketToggleMode(buffer.readInt());
    }

    public PacketToggleMode(int mode) {
        this.mode = mode;
    }

    public static class Handler {
        public static void handle(PacketToggleMode msg, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                ServerPlayer playerEntity = ((NetworkEvent.Context)ctx.get()).getSender();
                if (playerEntity == null) {
                    return;
                }
                ItemStack heldItem = AbstractGadget.getGadget((Player)playerEntity);
                if (heldItem.m_41619_()) {
                    return;
                }
                if (heldItem.m_41720_() instanceof GadgetBuilding) {
                    GadgetBuilding gadgetBuilding = (GadgetBuilding)heldItem.m_41720_();
                    gadgetBuilding.setMode(heldItem, msg.mode);
                } else if (heldItem.m_41720_() instanceof GadgetExchanger) {
                    GadgetExchanger gadgetExchanger = (GadgetExchanger)heldItem.m_41720_();
                    gadgetExchanger.setMode(heldItem, msg.mode);
                } else if (heldItem.m_41720_() instanceof GadgetCopyPaste) {
                    GadgetCopyPaste gadgetCopyPaste = (GadgetCopyPaste)heldItem.m_41720_();
                    gadgetCopyPaste.setMode(heldItem, msg.mode);
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

