/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.network.packets;

import com.direwolf20.buildinggadgets.common.BuildingGadgets;
import com.direwolf20.buildinggadgets.common.capability.CapabilityTemplate;
import com.direwolf20.buildinggadgets.common.items.OurItems;
import com.direwolf20.buildinggadgets.common.network.packets.UUIDPacket;
import com.direwolf20.buildinggadgets.common.tainted.template.ITemplateKey;
import com.direwolf20.buildinggadgets.common.tainted.template.ITemplateProvider;
import com.direwolf20.buildinggadgets.common.util.exceptions.CapabilityNotPresentException;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public final class PacketTemplateManagerTemplateCreated
extends UUIDPacket {
    private final BlockPos pos;

    public PacketTemplateManagerTemplateCreated(FriendlyByteBuf buffer) {
        super(buffer);
        this.pos = buffer.m_130135_();
    }

    public PacketTemplateManagerTemplateCreated(UUID id, BlockPos pos) {
        super(id);
        this.pos = pos;
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        super.encode(buffer);
        buffer.m_130064_(this.pos);
    }

    public void handle(Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context ctx = contextSupplier.get();
        ctx.enqueueWork(() -> {
            BlockEntity tileEntity;
            Level world;
            if (((NetworkEvent.Context)contextSupplier.get()).getDirection().getReceptionSide() == LogicalSide.SERVER && (world = ((NetworkEvent.Context)contextSupplier.get()).getSender().f_19853_).m_46805_(this.pos) && (tileEntity = world.m_7702_(this.pos)) != null) {
                tileEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(arg_0 -> this.lambda$handle$2(world, (Supplier)contextSupplier, arg_0));
            }
        });
        ctx.setPacketHandled(true);
    }

    private /* synthetic */ void lambda$handle$2(Level world, Supplier contextSupplier, IItemHandler handler) {
        ItemStack stack = new ItemStack((ItemLike)OurItems.TEMPLATE_ITEM.get());
        ITemplateKey key = (ITemplateKey)stack.getCapability(CapabilityTemplate.TEMPLATE_KEY_CAPABILITY).orElseThrow(CapabilityNotPresentException::new);
        UUID id = key.getTemplateId(this::getId);
        if (!id.equals(this.getId())) {
            BuildingGadgets.LOG.error("Failed to apply Template id on server!");
        } else {
            ((IItemHandlerModifiable)handler).setStackInSlot(1, stack);
            world.getCapability(CapabilityTemplate.TEMPLATE_PROVIDER_CAPABILITY).ifPresent(arg_0 -> PacketTemplateManagerTemplateCreated.lambda$handle$1(key, (Supplier)contextSupplier, arg_0));
        }
    }

    private static /* synthetic */ void lambda$handle$1(ITemplateKey key, Supplier contextSupplier, ITemplateProvider provider) {
        provider.requestUpdate(key, PacketDistributor.PLAYER.with(() -> PacketTemplateManagerTemplateCreated.lambda$handle$0((Supplier)contextSupplier)));
    }

    private static /* synthetic */ ServerPlayer lambda$handle$0(Supplier contextSupplier) {
        return ((NetworkEvent.Context)contextSupplier.get()).getSender();
    }
}

