/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.client;

import com.direwolf20.buildinggadgets.common.items.AbstractGadget;
import com.direwolf20.buildinggadgets.common.items.TemplateItem;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class KeyBindings {
    private static final Logger LOGGER = LoggerFactory.getLogger(KeyBindings.class);
    private static final KeyConflictContextGadget CONFLICT_CONTEXT_GADGET = new KeyConflictContextGadget();
    private static final List<KeyMapping> keyMappings = new ArrayList<KeyMapping>();
    public static KeyMapping menuSettings = KeyBindings.createBinding("settings_menu", 71);
    public static KeyMapping range = KeyBindings.createBinding("range", 82);
    public static KeyMapping undo = KeyBindings.createBinding("undo", 85);
    public static KeyMapping anchor = KeyBindings.createBinding("anchor", 72);
    public static KeyMapping fuzzy = KeyBindings.createBinding("fuzzy", -1);
    public static KeyMapping connectedArea = KeyBindings.createBinding("connected_area", -1);
    public static KeyMapping rotateMirror = KeyBindings.createBinding("rotate_mirror", -1);
    public static KeyMapping materialList = KeyBindings.createBinding("material_list", 77);

    public static void init() {
    }

    private static KeyMapping createBinding(String name, int key) {
        KeyMapping keyBinding = new KeyMapping(KeyBindings.getKey(name), (IKeyConflictContext)CONFLICT_CONTEXT_GADGET, InputConstants.Type.KEYSYM.m_84895_(key), KeyBindings.getKey("category"));
        keyMappings.add(keyBinding);
        return keyBinding;
    }

    private static String getKey(String name) {
        return String.join((CharSequence)".", "key", "buildinggadgets", name);
    }

    @SubscribeEvent
    static void register(RegisterKeyMappingsEvent event) {
        LOGGER.debug("Registering {} keybinding for {}", (Object)keyMappings.size(), (Object)"buildinggadgets");
        keyMappings.forEach(arg_0 -> ((RegisterKeyMappingsEvent)event).register(arg_0));
    }

    public static class KeyConflictContextGadget
    implements IKeyConflictContext {
        public boolean isActive() {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            return !KeyConflictContext.GUI.isActive() && player != null && (!AbstractGadget.getGadget((Player)player).m_41619_() || player.m_21120_(InteractionHand.MAIN_HAND).m_41720_() instanceof TemplateItem || player.m_21120_(InteractionHand.OFF_HAND).m_41720_() instanceof TemplateItem);
        }

        public boolean conflicts(IKeyConflictContext other) {
            return other == this || other == KeyConflictContext.IN_GAME;
        }
    }
}

