/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.net;

import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseC2SMessage;
import dev.architectury.networking.simple.MessageType;
import dev.ftb.mods.ftbquests.net.CreateObjectResponseMessage;
import dev.ftb.mods.ftbquests.net.FTBQuestsNetHandler;
import dev.ftb.mods.ftbquests.quest.Chapter;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.ServerQuestFile;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.quest.task.TaskType;
import dev.ftb.mods.ftbquests.util.NetUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;

public class CreateTaskAtMessage
extends BaseC2SMessage {
    private final long chapter;
    private final double x;
    private final double y;
    private final TaskType type;
    private final CompoundTag nbt;

    CreateTaskAtMessage(FriendlyByteBuf buffer) {
        this.chapter = buffer.readLong();
        this.x = buffer.readDouble();
        this.y = buffer.readDouble();
        this.type = (TaskType)ServerQuestFile.INSTANCE.taskTypeIds.get(buffer.m_130242_());
        this.nbt = buffer.m_130260_();
    }

    public CreateTaskAtMessage(Chapter c, double _x, double _y, Task task) {
        this.chapter = c.id;
        this.x = _x;
        this.y = _y;
        this.type = task.getType();
        this.nbt = new CompoundTag();
        task.writeData(this.nbt);
    }

    public MessageType getType() {
        return FTBQuestsNetHandler.CREATE_TASK_AT;
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeLong(this.chapter);
        buffer.writeDouble(this.x);
        buffer.writeDouble(this.y);
        buffer.m_130130_(this.type.intId);
        buffer.m_130079_(this.nbt);
    }

    public void handle(NetworkManager.PacketContext context) {
        Chapter c;
        if (NetUtils.canEdit(context) && (c = ServerQuestFile.INSTANCE.getChapter(this.chapter)) != null) {
            Quest quest = new Quest(c);
            quest.x = this.x;
            quest.y = this.y;
            quest.id = ServerQuestFile.INSTANCE.newID();
            quest.onCreated();
            new CreateObjectResponseMessage(quest, null).sendToAll(context.getPlayer().m_20194_());
            Task task = this.type.provider.create(quest);
            task.id = ServerQuestFile.INSTANCE.newID();
            task.readData(this.nbt);
            task.onCreated();
            CompoundTag extra = new CompoundTag();
            extra.m_128359_("type", this.type.getTypeForNBT());
            new CreateObjectResponseMessage(task, extra).sendToAll(context.getPlayer().m_20194_());
            ServerQuestFile.INSTANCE.refreshIDMap();
            ServerQuestFile.INSTANCE.clearCachedData();
            ServerQuestFile.INSTANCE.save();
        }
    }
}

