/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.net;

import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseC2SMessage;
import dev.architectury.networking.simple.MessageType;
import dev.ftb.mods.ftbquests.net.EditObjectResponseMessage;
import dev.ftb.mods.ftbquests.net.FTBQuestsNetHandler;
import dev.ftb.mods.ftbquests.quest.Chapter;
import dev.ftb.mods.ftbquests.quest.ChapterImage;
import dev.ftb.mods.ftbquests.quest.ServerQuestFile;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;

public class CopyChapterImageMessage
extends BaseC2SMessage {
    private final ChapterImage img;
    private final long chapterId;

    public CopyChapterImageMessage(ChapterImage toCopy, Chapter chapter, double x, double y) {
        this.img = new ChapterImage(chapter);
        CompoundTag tag = new CompoundTag();
        toCopy.writeData(tag);
        this.img.readData(tag);
        this.img.x = x;
        this.img.y = y;
        this.chapterId = chapter.id;
    }

    public CopyChapterImageMessage(FriendlyByteBuf buf) {
        this.chapterId = buf.readLong();
        this.img = new ChapterImage(ServerQuestFile.INSTANCE.getChapter(this.chapterId));
        this.img.readNetData(buf);
    }

    public MessageType getType() {
        return FTBQuestsNetHandler.COPY_CHAPTER_IMAGE;
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeLong(this.chapterId);
        this.img.writeNetData(buf);
    }

    public void handle(NetworkManager.PacketContext context) {
        this.img.chapter.images.add(this.img);
        this.img.chapter.file.save();
        new EditObjectResponseMessage(this.img.chapter).sendToAll(context.getPlayer().m_20194_());
    }
}

