/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.ad_astra.common.recipe.lunarian;

import com.google.gson.JsonObject;
import earth.terrarium.ad_astra.common.entity.LunarianMerchantOffer;
import earth.terrarium.ad_astra.common.recipe.lunarian.LunarianTradeRecipe;
import earth.terrarium.ad_astra.common.registry.ModRecipeSerializers;
import earth.terrarium.ad_astra.common.registry.ModRecipeTypes;
import java.util.function.BiFunction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;

public class LunarianTradeEnchantedItemRecipe
extends LunarianTradeRecipe {
    private int basePrice;

    public LunarianTradeEnchantedItemRecipe(ResourceLocation id) {
        super(id);
    }

    public LunarianTradeEnchantedItemRecipe(ResourceLocation id, Builder<LunarianTradeEnchantedItemRecipe> builder) {
        super(id, builder);
        this.basePrice = builder.basePrice;
    }

    @Override
    protected void fromJson(JsonObject json) {
        super.fromJson(json);
        this.basePrice = GsonHelper.m_13927_((JsonObject)json, (String)"basePrice");
    }

    @Override
    protected void toJson(JsonObject json) {
        super.toJson(json);
        json.addProperty("basePrice", (Number)this.basePrice);
    }

    @Override
    protected void fromNetwork(FriendlyByteBuf buffer) {
        super.fromNetwork(buffer);
        this.basePrice = buffer.readInt();
    }

    @Override
    protected void toNetwork(FriendlyByteBuf buffer) {
        super.toNetwork(buffer);
        buffer.writeInt(this.basePrice);
    }

    @Override
    public VillagerTrades.ItemListing toItemListing() {
        return new LunarianMerchantOffer.SellEnchantedToolFactory(this.getBuyA(), this.getBuyB(), this.getSell(), this.getBasePrice(), this.getMaxUses(), this.getExperience(), this.getMultiplier());
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipeSerializers.LUNARIAN_TRADE_ENCHANTED_ITEM_SERIALIZER.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)ModRecipeTypes.LUNARIAN_TRADE_ENCHANTED_ITEM_RECIPE.get();
    }

    @Override
    protected ItemStack getDefaultBuyA() {
        return LunarianMerchantOffer.SellEnchantedToolFactory.DEFAULT_BUY_A;
    }

    @Override
    protected ItemStack getDefaultBuyB() {
        return LunarianMerchantOffer.SellEnchantedToolFactory.DEFAULT_BUY_B;
    }

    @Override
    protected float getDefaultMultiplier() {
        return 0.05f;
    }

    public int getBasePrice() {
        return this.basePrice;
    }

    public static class Builder<RECIPE extends LunarianTradeEnchantedItemRecipe>
    extends LunarianTradeRecipe.Builder<RECIPE> {
        private int basePrice;

        public Builder(BiFunction<ResourceLocation, ? extends Builder<RECIPE>, RECIPE> function) {
            super(function);
        }

        public Builder<RECIPE> basePrice(int basePrice) {
            this.basePrice = basePrice;
            return this;
        }

        public int getBasePrice() {
            return this.basePrice;
        }
    }
}

