/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.ad_astra.common.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import earth.terrarium.ad_astra.common.data.ButtonColor;
import java.util.Optional;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public record Planet(String translation, ResourceLocation galaxy, ResourceLocation solarSystem, ResourceKey<Level> level, ResourceKey<Level> orbitWorld, ResourceKey<Level> parentWorld, int rocketTier, float gravity, boolean hasAtmosphere, int daysInYear, float temperature, long solarPower, long orbitSolarPower, boolean hasOxygen, ButtonColor buttonColor) {
    public static final Codec<Planet> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("translation").forGetter(Planet::translation), (App)ResourceLocation.f_135803_.fieldOf("galaxy").forGetter(Planet::galaxy), (App)ResourceLocation.f_135803_.fieldOf("solar_system").forGetter(Planet::solarSystem), (App)ResourceKey.m_195966_((ResourceKey)Registry.f_122819_).fieldOf("world").forGetter(Planet::level), (App)ResourceKey.m_195966_((ResourceKey)Registry.f_122819_).fieldOf("orbit_world").forGetter(Planet::orbitWorld), (App)ResourceKey.m_195966_((ResourceKey)Registry.f_122819_).optionalFieldOf("parent_world").forGetter(Planet::getParentlevel), (App)Codec.INT.fieldOf("rocket_tier").forGetter(Planet::rocketTier), (App)Codec.FLOAT.fieldOf("gravity").forGetter(Planet::gravity), (App)Codec.BOOL.fieldOf("has_atmosphere").forGetter(Planet::hasAtmosphere), (App)Codec.INT.fieldOf("days_in_year").forGetter(Planet::daysInYear), (App)Codec.FLOAT.fieldOf("temperature").forGetter(Planet::temperature), (App)Codec.LONG.fieldOf("solar_power").forGetter(Planet::solarPower), (App)Codec.LONG.fieldOf("orbit_solar_power").forGetter(Planet::orbitSolarPower), (App)Codec.BOOL.fieldOf("has_oxygen").forGetter(Planet::hasOxygen), (App)ButtonColor.CODEC.fieldOf("button_color").forGetter(Planet::buttonColor)).apply((Applicative)instance, Planet::new));

    public Planet(String translation, ResourceLocation galaxy, ResourceLocation solarSystem, ResourceKey<Level> level, ResourceKey<Level> orbitWorld, Optional<ResourceKey<Level>> parentWorld, int rocketTier, float gravity, boolean hasAtmosphere, int daysInYear, float temperature, long solarPower, long orbitSolarPower, boolean hasOxygen, ButtonColor buttonColor) {
        this(translation, galaxy, solarSystem, level, orbitWorld, (ResourceKey<Level>)((ResourceKey)parentWorld.orElse(null)), rocketTier, gravity, hasAtmosphere, daysInYear, temperature, solarPower, orbitSolarPower, hasOxygen, buttonColor);
    }

    private Optional<ResourceKey<Level>> getParentlevel() {
        return Optional.ofNullable(this.parentWorld);
    }
}

