/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.ad_astra.common.container;

import earth.terrarium.botarium.api.Updatable;
import earth.terrarium.botarium.api.fluid.FluidContainer;
import earth.terrarium.botarium.api.fluid.FluidHolder;
import earth.terrarium.botarium.api.fluid.FluidHooks;
import earth.terrarium.botarium.api.fluid.FluidSnapshot;
import earth.terrarium.botarium.api.fluid.SimpleUpdatingFluidContainer;
import earth.terrarium.botarium.api.fluid.UpdatingFluidContainer;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.entity.BlockEntity;

public class DoubleFluidTank
implements UpdatingFluidContainer<BlockEntity> {
    private final SimpleUpdatingFluidContainer input;
    private final SimpleUpdatingFluidContainer output;

    public DoubleFluidTank(Updatable updatable, long inputCapacity, long outputCapacity, Predicate<FluidHolder> inputFilter, Predicate<FluidHolder> outputFilter) {
        this.input = new SimpleUpdatingFluidContainer(updatable, i -> inputCapacity, 1, (i, f) -> inputFilter.test((FluidHolder)f));
        this.output = new SimpleUpdatingFluidContainer(updatable, i -> outputCapacity, 1, (i, f) -> outputFilter.test((FluidHolder)f));
    }

    protected DoubleFluidTank(SimpleUpdatingFluidContainer input, SimpleUpdatingFluidContainer output) {
        this.input = input;
        this.output = output;
    }

    public long insertFluid(FluidHolder fluid, boolean simulate) {
        if (fluid.isEmpty()) {
            return 0L;
        }
        return this.input.insertFluid(fluid, simulate);
    }

    public FluidHolder extractFluid(FluidHolder fluid, boolean simulate) {
        if (fluid.isEmpty()) {
            return FluidHooks.emptyFluid();
        }
        return this.output.extractFluid(fluid, simulate);
    }

    public void setFluid(int slot, FluidHolder fluid) {
    }

    public List<FluidHolder> getFluids() {
        return List.of((FluidHolder)this.input.getFluids().get(0), (FluidHolder)this.output.getFluids().get(0));
    }

    public int getSize() {
        return 2;
    }

    public boolean isEmpty() {
        return this.input.isEmpty() && this.output.isEmpty();
    }

    public FluidContainer copy() {
        return new DoubleFluidTank(this.input.copy(), this.output.copy());
    }

    public long getTankCapacity(int tankSlot) {
        return tankSlot == 0 ? this.input.getTankCapacity(0) : this.output.getTankCapacity(0);
    }

    public void fromContainer(FluidContainer container) {
        if (container instanceof DoubleFluidTank) {
            DoubleFluidTank doubleFluidTank = (DoubleFluidTank)container;
            this.input.fromContainer((FluidContainer)doubleFluidTank.input);
            this.output.fromContainer((FluidContainer)doubleFluidTank.output);
        }
    }

    public long extractFromSlot(FluidHolder fluidHolder, FluidHolder toInsert, Runnable snapshot) {
        return this.output.extractFromSlot(fluidHolder, toInsert, snapshot);
    }

    public boolean allowsInsertion() {
        return true;
    }

    public boolean allowsExtraction() {
        return true;
    }

    public FluidSnapshot createSnapshot() {
        return new DoubleTankSnapshot(this.input.createSnapshot(), this.output.createSnapshot());
    }

    public void deserialize(CompoundTag nbtCompound) {
        this.input.deserialize(nbtCompound.m_128469_("Input"));
        this.output.deserialize(nbtCompound.m_128469_("Output"));
    }

    public CompoundTag serialize(CompoundTag nbtCompound) {
        nbtCompound.m_128365_("Input", (Tag)this.input.serialize(new CompoundTag()));
        nbtCompound.m_128365_("Output", (Tag)this.output.serialize(new CompoundTag()));
        return nbtCompound;
    }

    public FluidContainer getInput() {
        return this.input;
    }

    public FluidContainer getOutput() {
        return this.output;
    }

    public void update(BlockEntity updatable) {
    }

    private record DoubleTankSnapshot(FluidSnapshot input, FluidSnapshot output) implements FluidSnapshot
    {
        public void loadSnapshot(FluidContainer container) {
            if (container instanceof DoubleFluidTank) {
                DoubleFluidTank doubleFluidTank = (DoubleFluidTank)container;
                this.input.loadSnapshot((FluidContainer)doubleFluidTank.input);
                this.output.loadSnapshot((FluidContainer)doubleFluidTank.output);
            }
        }
    }
}

