/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.controls.tree;

import javax.annotation.Nullable;
import team.creative.creativecore.common.gui.GuiChildControl;
import team.creative.creativecore.common.gui.controls.tree.GuiTreeItem;

public class GuiTreeDragPosition {
    public final ItemPosition position;
    public final GuiChildControl child;
    public final GuiChildControl above;
    public final GuiTreeItem item;

    public GuiTreeDragPosition(ItemPosition position, GuiChildControl child, GuiTreeItem item, @Nullable GuiChildControl above) {
        this.position = position;
        this.child = child;
        this.item = item;
        this.above = above;
    }

    public void insert(GuiTreeItem item) {
        this.position.insert(item, this.item);
    }

    public String toString() {
        return this.position.name() + "," + this.child;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum ItemPosition {
        ABOVE{

            @Override
            public void insert(GuiTreeItem toAdd, GuiTreeItem reference) {
                GuiTreeItem parent = reference.getParentItem();
                parent.insertItem(parent.indexOf(reference), toAdd);
            }
        }
        ,
        IN{

            @Override
            public void insert(GuiTreeItem toAdd, GuiTreeItem reference) {
                reference.addItem(toAdd);
            }
        }
        ,
        BELOW{

            @Override
            public void insert(GuiTreeItem toAdd, GuiTreeItem reference) {
                GuiTreeItem parent = reference.getParentItem();
                int index = parent.indexOf(reference);
                if (index >= parent.itemsCount() - 1) {
                    parent.addItem(toAdd);
                } else {
                    parent.insertItem(index + 1, toAdd);
                }
            }
        };


        public abstract void insert(GuiTreeItem var1, GuiTreeItem var2);
    }
}

