/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.controls.tree;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import team.creative.creativecore.common.gui.GuiChildControl;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.controls.parent.GuiScrollXY;
import team.creative.creativecore.common.gui.controls.simple.GuiTextfield;
import team.creative.creativecore.common.gui.controls.tree.GuiTreeDragPosition;
import team.creative.creativecore.common.gui.controls.tree.GuiTreeItem;
import team.creative.creativecore.common.gui.flow.GuiFlow;
import team.creative.creativecore.common.gui.style.ControlFormatting;
import team.creative.creativecore.common.gui.style.display.DisplayColor;
import team.creative.creativecore.common.gui.style.display.StyleDisplay;
import team.creative.creativecore.common.util.math.geo.Rect;
import team.creative.creativecore.common.util.mc.ColorUtils;

public class GuiTree
extends GuiScrollXY {
    private static final int levelSpacing = 10;
    private int lastWidth;
    private int lastHeight;
    private boolean searchbar = false;
    private final GuiTextfield search;
    private boolean visibleRoot = false;
    private final GuiTreeItem root;
    protected StyleDisplay line = new DisplayColor(-1);
    protected StyleDisplay dragLine = new DisplayColor(-16777216);
    protected StyleDisplay dragHover = new DisplayColor(ColorUtils.rgb(200, 150, 0));
    private int lineThickness;
    private int halfLineThickness;
    private GuiTreeItem selected = null;
    private GuiTreeItem dragged = null;
    private GuiTreeDragPosition lastDragPosition = null;

    public GuiTree(String name) {
        this(name, false);
    }

    public GuiTree(String name, boolean searchbar) {
        super(name, GuiFlow.STACK_Y);
        this.searchbar = searchbar;
        this.search = searchbar ? new GuiTextfield(name) : null;
        this.root = new GuiTreeItem("root", this);
        this.spacing = 3;
        this.setLineThickness(1);
    }

    public GuiTree(String name, int width, int height, boolean searchbar) {
        super(name, (GuiFlow)GuiFlow.STACK_Y, width, height);
        this.searchbar = searchbar;
        this.search = searchbar ? new GuiTextfield(name) : null;
        this.root = new GuiTreeItem("root", this);
        this.spacing = 3;
        this.setLineThickness(1);
    }

    public void select(GuiTreeItem item) {
        if (this.selected != null) {
            this.selected.deselect();
        }
        if (item != null) {
            item.select();
        }
        this.selected = item;
    }

    public void setLineThickness(int thickness) {
        this.lineThickness = thickness;
        this.halfLineThickness = thickness / 2;
    }

    public GuiTree setRootVisibility(boolean visible) {
        this.visibleRoot = visible;
        return this;
    }

    public GuiTreeItem root() {
        return this.root;
    }

    public void updateTree() {
        this.clear();
        if (this.searchbar) {
            this.add(this.search);
        }
        if (this.visibleRoot) {
            this.add(this.root);
        }
        if (!this.visibleRoot || this.root.opened()) {
            this.addItem(this.root);
        }
        if (this.lastWidth != 0) {
            this.flowX(this.lastWidth, this.getPreferredWidth());
            this.flowY(this.lastWidth, this.lastHeight, this.getPreferredHeight(this.lastWidth));
        }
    }

    private void addItem(GuiTreeItem item) {
        for (GuiTreeItem subItem : item.items()) {
            this.add(subItem);
            if (!subItem.opened()) continue;
            this.addItem(subItem);
        }
    }

    protected int offsetByLevel(int level) {
        if (this.visibleRoot) {
            return 10 * level;
        }
        return 10 * (level - 1);
    }

    @Override
    protected int preferredWidth() {
        int width = 0;
        for (GuiChildControl child : this.controls) {
            GuiControl guiControl = child.control;
            if (guiControl instanceof GuiTreeItem) {
                GuiTreeItem item = (GuiTreeItem)guiControl;
                width = Math.max(width, this.offsetByLevel(item.getLevel()) + 1 + child.getPreferredWidth());
                continue;
            }
            width = Math.max(width, child.getPreferredWidth());
        }
        return width;
    }

    @Override
    public void flowX(int width, int preferred) {
        super.flowX(width, preferred);
        for (GuiChildControl child : this.controls) {
            GuiControl guiControl = child.control;
            if (!(guiControl instanceof GuiTreeItem)) continue;
            GuiTreeItem item = (GuiTreeItem)guiControl;
            child.setX(this.offsetByLevel(item.getLevel()) + 1);
        }
        this.updateWidth();
        this.lastWidth = width;
    }

    @Override
    public void flowY(int width, int height, int preferred) {
        super.flowY(width, height, preferred);
        this.lastHeight = height;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void renderContent(PoseStack matrix, GuiChildControl control, ControlFormatting formatting, int borderWidth, Rect controlRect, Rect realRect, int mouseX, int mouseY) {
        if (this.isDragged()) {
            matrix.m_85836_();
            matrix.m_85837_((double)this.getContentOffset() + this.getOffsetX(), (double)this.getContentOffset() + this.getOffsetY(), 0.0);
            this.lastDragPosition = this.calculatePosition((int)((double)mouseX - realRect.minX - (double)this.getContentOffset()), (int)((double)mouseY - realRect.minY - (double)this.getContentOffset()));
            if (this.lastDragPosition != null) {
                if (this.lastDragPosition.position == GuiTreeDragPosition.ItemPosition.IN) {
                    this.dragHover.render(matrix, this.lastDragPosition.child.rect.minX, this.lastDragPosition.child.rect.minY, this.lastDragPosition.child.rect.getWidth(), this.lastDragPosition.child.rect.getHeight());
                } else {
                    int minY;
                    int thickness = 1;
                    int width = (int)this.lastDragPosition.child.rect.getWidth();
                    if (this.lastDragPosition.position == GuiTreeDragPosition.ItemPosition.ABOVE) {
                        minY = (int)(this.lastDragPosition.child.rect.minY - (double)thickness) - 1;
                        if (this.lastDragPosition.above != null) {
                            width = Math.max(width, (int)this.lastDragPosition.above.rect.getWidth());
                        }
                    } else {
                        minY = (int)this.lastDragPosition.child.rect.maxY + 1;
                    }
                    if (this.lastDragPosition.above != null) {
                        this.dragLine.render(matrix, this.lastDragPosition.child.rect.minX - (double)thickness, minY - thickness, thickness, thickness * 3);
                        this.dragLine.render(matrix, this.lastDragPosition.child.rect.minX + (double)width, minY - thickness, thickness, thickness * 3);
                    } else if (this.lastDragPosition.position == GuiTreeDragPosition.ItemPosition.ABOVE) {
                        this.dragLine.render(matrix, this.lastDragPosition.child.rect.minX - (double)thickness, minY, thickness, thickness * 2);
                        this.dragLine.render(matrix, this.lastDragPosition.child.rect.minX + (double)width, minY, thickness, thickness * 2);
                    } else {
                        this.dragLine.render(matrix, this.lastDragPosition.child.rect.minX - (double)thickness, minY - thickness, thickness, thickness * 2);
                        this.dragLine.render(matrix, this.lastDragPosition.child.rect.minX + (double)width, minY - thickness, thickness, thickness * 2);
                    }
                    this.dragLine.render(matrix, this.lastDragPosition.child.rect.minX, minY, width, thickness);
                }
            }
            matrix.m_85849_();
        } else {
            this.lastDragPosition = null;
        }
        super.renderContent(matrix, control, formatting, borderWidth, controlRect, realRect, mouseX, mouseY);
        matrix.m_85836_();
        matrix.m_85837_(this.getOffsetX(), (double)this.getContentOffset() + this.getOffsetY(), 0.0);
        ArrayList<GuiTreeLine> lines = new ArrayList<GuiTreeLine>();
        int size = -1;
        for (GuiChildControl child : this.controls) {
            if (!(child.control instanceof GuiTreeItem)) continue;
            GuiTreeItem item = (GuiTreeItem)child.control;
            int lineY = (int)((child.rect.minY + child.rect.maxY) / 2.0) + this.halfLineThickness;
            int level = item.getLevel() - (this.visibleRoot ? 1 : 2);
            if (level <= size) {
                if (level >= 0) {
                    ((GuiTreeLine)lines.get((int)level)).y2 = lineY;
                }
                for (int i = size; i > level; --i) {
                    if (((GuiTreeLine)lines.get((int)i)).invalid) continue;
                    ((GuiTreeLine)lines.get(i)).render(matrix);
                    ((GuiTreeLine)lines.get((int)i)).invalid = false;
                }
                size = level;
            } else {
                if (level < 0) continue;
                while (level > size) {
                    if (lines.size() > size + 1) {
                        ((GuiTreeLine)lines.get(level)).set((int)child.rect.minY - 2, lineY);
                    } else {
                        lines.add(new GuiTreeLine(size + 1, (int)child.rect.minY - 2, lineY));
                    }
                    ++size;
                }
            }
            if (level < 0) continue;
            this.line.render(matrix, ((GuiTreeLine)lines.get((int)level)).x + this.lineThickness, lineY - this.lineThickness, 5.0, this.lineThickness);
        }
        if (size >= 0) {
            for (int i = size; i > -1; --i) {
                if (((GuiTreeLine)lines.get((int)i)).invalid) continue;
                ((GuiTreeLine)lines.get(i)).render(matrix);
                ((GuiTreeLine)lines.get((int)i)).invalid = false;
            }
        }
        matrix.m_85849_();
    }

    @Override
    public boolean mouseClicked(Rect rect, double x, double y, int button) {
        if (super.mouseClicked(rect, x, y, button)) {
            return true;
        }
        this.select(null);
        return true;
    }

    private GuiTreeDragPosition createPosition(GuiTreeDragPosition.ItemPosition position, GuiChildControl child, GuiTreeItem item, GuiChildControl before) {
        GuiTreeItem item2;
        GuiControl guiControl;
        if (item == this.root && position != GuiTreeDragPosition.ItemPosition.IN) {
            return null;
        }
        return new GuiTreeDragPosition(position, child, item, before != null && (guiControl = before.control) instanceof GuiTreeItem && (item2 = (GuiTreeItem)guiControl).getLevel() == item.getLevel() ? before : null);
    }

    protected GuiTreeDragPosition calculatePosition(int mouseX, int mouseY) {
        GuiChildControl last = null;
        GuiChildControl before = null;
        for (GuiChildControl child : this.controls) {
            if (child.control == this.dragged) continue;
            GuiControl guiControl = child.control;
            if (guiControl instanceof GuiTreeItem) {
                GuiTreeItem item = (GuiTreeItem)guiControl;
                if (child.rect.minY > (double)mouseY) {
                    return this.createPosition(GuiTreeDragPosition.ItemPosition.ABOVE, child, item, before);
                }
                if (child.rect.inside(mouseX, mouseY)) {
                    return this.createPosition(GuiTreeDragPosition.ItemPosition.IN, child, item, before);
                }
                last = child;
            }
            before = child;
        }
        if (last != null) {
            return this.createPosition(GuiTreeDragPosition.ItemPosition.BELOW, last, (GuiTreeItem)last.control, null);
        }
        return null;
    }

    public boolean performModication(GuiTreeItem item, GuiTreeDragPosition position) {
        if (item.isChild(position.item)) {
            return false;
        }
        if (!item.getParentItem().removeItem(item)) {
            return false;
        }
        position.insert(item);
        this.updateTree();
        return true;
    }

    public boolean moveUp() {
        if (this.selected == null) {
            return false;
        }
        GuiTreeItem parent = this.selected.getParentItem();
        if (parent == null) {
            return false;
        }
        int index = parent.indexOf(this.selected);
        if (index <= 0) {
            return false;
        }
        return this.performModication(this.selected, new GuiTreeDragPosition(GuiTreeDragPosition.ItemPosition.ABOVE, null, parent.getItem(index - 1), null));
    }

    public boolean moveDown() {
        if (this.selected == null) {
            return false;
        }
        GuiTreeItem parent = this.selected.getParentItem();
        if (parent == null) {
            return false;
        }
        int index = parent.indexOf(this.selected);
        if (index >= parent.itemsCount() - 1) {
            return false;
        }
        return this.performModication(this.selected, new GuiTreeDragPosition(GuiTreeDragPosition.ItemPosition.BELOW, null, parent.getItem(index + 1), null));
    }

    public boolean isDragged() {
        return this.dragged != null;
    }

    public void startDrag(GuiTreeItem item) {
        this.dragged = item;
    }

    public boolean endDrag() {
        this.performModication(this.dragged, this.lastDragPosition);
        this.lastDragPosition = null;
        this.dragged = null;
        return true;
    }

    private class GuiTreeLine {
        public final int x;
        public int y;
        public int y2;
        public boolean invalid;

        public GuiTreeLine(int level, int minY, int maxY) {
            this.x = GuiTree.this.offsetByLevel(level + (GuiTree.this.visibleRoot ? 1 : 2)) - 5;
            this.set(minY, maxY);
        }

        public void set(int minY, int maxY) {
            this.y = minY;
            this.y2 = maxY;
            this.invalid = false;
        }

        public void render(PoseStack pose) {
            GuiTree.this.line.render(pose, this.x, this.y, GuiTree.this.lineThickness, this.y2 - this.y);
        }
    }
}

