/*
 * Decompiled with CFR 0.152.
 */
package shadows.placebo.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.util.Mth;

public class TickableText {
    protected int ticks = 0;
    protected final String message;
    protected final int color;
    protected final boolean newline;
    protected final float tickRate;

    public TickableText(String message, int color, boolean newline, float tickRate) {
        this.message = message;
        this.color = color;
        this.newline = newline;
        this.tickRate = tickRate;
    }

    public TickableText(String message, int color) {
        this(message, color, true, 1.0f);
    }

    public void tick() {
        ++this.ticks;
    }

    public TickableText setTicks(int ticks) {
        this.ticks = ticks;
        return this;
    }

    public void render(Font font, PoseStack stack, int x, int y) {
        font.m_92883_(stack, this.message.substring(0, Mth.m_14167_((float)Math.min((float)this.ticks * this.tickRate, (float)this.message.length()))), (float)x, (float)y, this.color);
    }

    public int getMaxUsefulTicks() {
        return Mth.m_14143_((float)((float)this.message.length() / this.tickRate));
    }

    public void reset() {
        this.ticks = 0;
    }

    public boolean isDone() {
        return (float)this.ticks * this.tickRate >= (float)this.message.length();
    }

    public boolean causesNewLine() {
        return this.newline;
    }

    public int getWidth(Font font) {
        return font.m_92895_(this.message);
    }

    public static void tickList(List<TickableText> texts) {
        for (int i = 0; i < texts.size(); ++i) {
            TickableText txt = texts.get(i);
            if (txt.isDone()) continue;
            txt.tick();
            break;
        }
    }
}

