/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.util;

import com.mrh0.createaddition.energy.WireType;
import com.mrh0.createaddition.item.WireSpool;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraftforge.energy.IEnergyStorage;

public class Util {
    public static int max(int ... v) {
        int m = Integer.MIN_VALUE;
        for (int i : v) {
            if (i <= m) continue;
            m = i;
        }
        return m;
    }

    public static int min(int ... v) {
        int m = Integer.MAX_VALUE;
        for (int i : v) {
            if (i >= m) continue;
            m = i;
        }
        return m;
    }

    public static int minIndex(int ... v) {
        int m = 0;
        for (int i = 0; i < v.length; ++i) {
            if (v[i] >= v[m]) continue;
            m = i;
        }
        return m;
    }

    public static ItemStack findStack(Item item, Inventory inv) {
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41720_() != item) continue;
            return stack;
        }
        return ItemStack.f_41583_;
    }

    public static boolean canStack(ItemStack add, ItemStack to) {
        return add.m_41613_() + to.m_41613_() <= to.m_41741_() && add.m_41720_() == to.m_41720_() || to.m_41619_();
    }

    public static int getMergeRest(ItemStack add, ItemStack to) {
        return Math.max(add.m_41613_() + to.m_41613_() - to.m_41741_(), 0);
    }

    public static int getSkyLight(Level world, BlockPos pos) {
        return Math.max(world.m_45517_(LightLayer.SKY, pos) - world.m_7445_(), 0);
    }

    public static ItemStack mergeStack(ItemStack add, ItemStack to) {
        return new ItemStack((ItemLike)(to.m_41619_() ? add.m_41720_() : to.m_41720_()), to.m_41613_() + add.m_41613_());
    }

    public static String format(int n) {
        if (n > 1000000000) {
            return (double)Math.round((double)n / 1.0E8) / 10.0 + "G";
        }
        if (n > 1000000) {
            return (double)Math.round((double)n / 100000.0) / 10.0 + "M";
        }
        if (n > 1000) {
            return (double)Math.round((double)n / 100.0) / 10.0 + "K";
        }
        return "" + n;
    }

    public static MutableComponent getTextComponent(IEnergyStorage ies, String nan, String unit) {
        if (ies == null) {
            return Component.m_237113_((String)nan);
        }
        return Util.getTextComponent(ies.getEnergyStored(), unit).m_130940_(ChatFormatting.AQUA).m_7220_((Component)Component.m_237113_((String)" / ").m_130940_(ChatFormatting.GRAY)).m_7220_((Component)Util.getTextComponent(ies.getMaxEnergyStored(), unit));
    }

    public static MutableComponent getTextComponent(IEnergyStorage ies) {
        return Util.getTextComponent(ies, "NaN", "fe");
    }

    public static MutableComponent getTextComponent(int value, String unit) {
        return Component.m_237113_((String)(Util.format(value) + unit));
    }

    public static Triple<BlockPos, Integer, WireType> getWireNodeOfSpools(ItemStack ... stacks) {
        for (ItemStack stack : stacks) {
            if (stack.m_41619_() || stack.m_41783_() == null || !WireSpool.hasPos(stack.m_41783_())) continue;
            return Triple.of(WireSpool.getPos(stack.m_41783_()), WireSpool.getNode(stack.m_41783_()), WireType.of(stack.m_41720_()));
        }
        return null;
    }

    public static class Triple<A, B, C> {
        public final A a;
        public final B b;
        public final C c;

        private Triple(A a, B b, C c) {
            this.a = a;
            this.b = b;
            this.c = c;
        }

        public static <A, B, C> Triple<A, B, C> of(A a, B b, C c) {
            return new Triple<A, B, C>(a, b, c);
        }
    }
}

