/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.module.hint;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import vazkii.arl.util.RegistryHelper;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.module.config.ConfigFlagManager;
import vazkii.quark.base.module.hint.Hint;
import vazkii.quark.base.module.hint.HintObject;

public class HintManager {
    public static void loadHints(List<Field> fields, ConfigFlagManager flagManager, QuarkModule module) {
        for (Field f : fields) {
            f.setAccessible(true);
            Hint hint = f.getDeclaredAnnotation(Hint.class);
            if (hint == null) continue;
            ArrayList<Supplier<Object>> list = new ArrayList<Supplier<Object>>();
            for (String h : hint.content()) {
                Field cf2;
                block3: {
                    if (h.isEmpty()) break;
                    for (Field cf2 : fields) {
                        if (!cf2.getName().equals(h)) continue;
                        break block3;
                    }
                    throw new AssertionError((Object)String.format("Missing field %s in module %s for hint %s", h, module, f));
                }
                list.add(() -> {
                    try {
                        return cf2.get(module);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                });
            }
            HintObject hintObj = new HintObject(flagManager, module, hint, list, () -> {
                try {
                    return Optional.ofNullable(f.get(module));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
            module.hints.add(hintObj);
        }
    }

    public static void hintItem(BiConsumer<Item, Component> consumer, ItemLike itemLike, Object ... extraContent) {
        Item item = itemLike.m_5456_();
        ResourceLocation res = RegistryHelper.getRegistryName((Object)item, (Registry)Registry.f_122827_);
        Object ns = res.m_135827_();
        String path = res.m_135815_();
        ns = ((String)ns).equals("quark") ? "" : (String)ns + ".";
        HintManager.hintItem(consumer, (ItemLike)item, (String)ns + path, extraContent);
    }

    public static void hintItem(BiConsumer<Item, Component> consumer, ItemLike itemLike, String key, Object ... extraContent) {
        Item item = itemLike.m_5456_();
        String hint = "quark.jei.hint." + key;
        consumer.accept(item, (Component)Component.m_237110_((String)hint, (Object[])extraContent));
    }
}

