/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.overlay;

import java.util.List;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.common.Internal;
import mezz.jei.common.gui.textures.Textures;
import mezz.jei.common.input.IInternalKeyMappings;
import mezz.jei.common.network.IConnectionToServer;
import mezz.jei.common.network.packets.PacketRequestCheatPermission;
import mezz.jei.common.platform.IPlatformConfigHelper;
import mezz.jei.common.platform.Services;
import mezz.jei.core.config.IWorldConfig;
import mezz.jei.gui.elements.GuiIconToggleButton;
import mezz.jei.gui.input.UserInput;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;

public class ConfigButton
extends GuiIconToggleButton {
    private final IInternalKeyMappings keyBindings;
    private final BooleanSupplier isListDisplayed;
    private final IWorldConfig worldConfig;

    public static ConfigButton create(BooleanSupplier isListDisplayed, IWorldConfig worldConfig, Textures textures, IInternalKeyMappings keyBindings) {
        return new ConfigButton(textures.getConfigButtonIcon(), textures.getConfigButtonCheatIcon(), isListDisplayed, worldConfig, textures, keyBindings);
    }

    private ConfigButton(IDrawable disabledIcon, IDrawable enabledIcon, BooleanSupplier isListDisplayed, IWorldConfig worldConfig, Textures textures, IInternalKeyMappings keyBindings) {
        super(disabledIcon, enabledIcon, textures);
        this.isListDisplayed = isListDisplayed;
        this.worldConfig = worldConfig;
        this.keyBindings = keyBindings;
    }

    @Override
    protected void getTooltips(List<Component> tooltip) {
        tooltip.add((Component)Component.m_237115_((String)"jei.tooltip.config"));
        if (!this.worldConfig.isOverlayEnabled()) {
            MutableComponent disabled = Component.m_237115_((String)"jei.tooltip.ingredient.list.disabled");
            MutableComponent disabledFix = Component.m_237110_((String)"jei.tooltip.ingredient.list.disabled.how.to.fix", (Object[])new Object[]{this.keyBindings.getToggleOverlay().getTranslatedKeyMessage()});
            tooltip.add((Component)disabled.m_130940_(ChatFormatting.GOLD));
            tooltip.add((Component)disabledFix.m_130940_(ChatFormatting.GOLD));
        } else if (!this.isListDisplayed.getAsBoolean()) {
            MutableComponent notEnoughSpace = Component.m_237115_((String)"jei.tooltip.not.enough.space");
            tooltip.add((Component)notEnoughSpace.m_130940_(ChatFormatting.GOLD));
        }
        if (this.worldConfig.isCheatItemsEnabled()) {
            MutableComponent enabled = Component.m_237115_((String)"jei.tooltip.cheat.mode.button.enabled").m_130940_(ChatFormatting.RED);
            tooltip.add((Component)enabled);
            if (!this.keyBindings.getToggleCheatMode().isUnbound()) {
                component = Component.m_237110_((String)"jei.tooltip.cheat.mode.how.to.disable.hotkey", (Object[])new Object[]{this.keyBindings.getToggleCheatMode().getTranslatedKeyMessage()}).m_130940_(ChatFormatting.RED);
                tooltip.add((Component)component);
            } else if (!this.keyBindings.getToggleCheatModeConfigButton().isUnbound()) {
                component = Component.m_237110_((String)"jei.tooltip.cheat.mode.how.to.disable.hover.config.button.hotkey", (Object[])new Object[]{this.keyBindings.getToggleCheatModeConfigButton().getTranslatedKeyMessage()}).m_130940_(ChatFormatting.RED);
                tooltip.add((Component)component);
            }
        }
    }

    @Override
    protected boolean isIconToggledOn() {
        return this.worldConfig.isCheatItemsEnabled();
    }

    @Override
    protected boolean onMouseClicked(UserInput input) {
        if (this.worldConfig.isOverlayEnabled()) {
            if (!input.isSimulate()) {
                if (input.is(this.keyBindings.getToggleCheatModeConfigButton())) {
                    this.worldConfig.toggleCheatItemsEnabled();
                    if (this.worldConfig.isCheatItemsEnabled()) {
                        IConnectionToServer serverConnection = Internal.getServerConnection();
                        serverConnection.sendPacketToServer(new PacketRequestCheatPermission());
                    }
                } else {
                    ConfigButton.openSettings();
                }
            }
            return true;
        }
        return false;
    }

    private static void openSettings() {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return;
        }
        IPlatformConfigHelper configHelper = Services.PLATFORM.getConfigHelper();
        Optional<Screen> configScreen = configHelper.getConfigScreen();
        if (configScreen.isPresent()) {
            mc.m_91152_(configScreen.get());
        } else {
            Component message = ConfigButton.getMissingConfigScreenMessage(configHelper);
            mc.f_91074_.m_5661_(message, false);
        }
    }

    private static Component getMissingConfigScreenMessage(IPlatformConfigHelper configHelper) {
        return Component.m_237115_((String)"jei.message.configured").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_BLUE).m_131162_(Boolean.valueOf(true)).m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://www.curseforge.com/minecraft/mc-mods/configured"))).m_130946_("\n").m_7220_((Component)Component.m_237115_((String)"jei.message.config.folder").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.WHITE).m_131162_(Boolean.valueOf(true)).m_131142_(new ClickEvent(ClickEvent.Action.OPEN_FILE, configHelper.createJeiConfigDir().toAbsolutePath().toString()))));
    }
}

