/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.core.config.file;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import mezz.jei.core.config.file.ConfigCategory;
import mezz.jei.core.config.file.ConfigCategoryBuilder;
import mezz.jei.core.config.file.ConfigSerializer;
import mezz.jei.core.config.file.FileWatcher;
import mezz.jei.core.config.file.IConfigSchema;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Unmodifiable;

public class ConfigSchema
implements IConfigSchema {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Path path;
    private final @Unmodifiable Map<String, ConfigCategory> categories;
    private final AtomicBoolean needsLoad = new AtomicBoolean(true);

    public ConfigSchema(Path path, List<ConfigCategoryBuilder> categoryBuilders) {
        this.path = path;
        LinkedHashMap<String, ConfigCategory> map = new LinkedHashMap<String, ConfigCategory>();
        for (ConfigCategoryBuilder builder : categoryBuilders) {
            ConfigCategory category = builder.build(this);
            map.put(category.getName(), category);
        }
        this.categories = Collections.unmodifiableMap(map);
    }

    @Override
    public void loadIfNeeded() {
        if (!this.needsLoad.get()) {
            return;
        }
        this.needsLoad.set(false);
        if (Files.exists(this.path, new LinkOption[0])) {
            try {
                ConfigSerializer.load(this.path, this.categories);
            }
            catch (IOException e) {
                LOGGER.error("Failed to load config schema for: %s".formatted(this.path), (Throwable)e);
            }
        }
    }

    private void onFileChanged() {
        this.needsLoad.set(true);
    }

    @Override
    public void register(FileWatcher fileWatcher) {
        if (!Files.exists(this.path, new LinkOption[0])) {
            try {
                ConfigSerializer.save(this.path, this.categories.values());
            }
            catch (IOException e) {
                LOGGER.error("Failed to create config file: '{}'", (Object)this.path, (Object)e);
            }
        }
        fileWatcher.addCallback(this.path, this::onFileChanged);
    }
}

