/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.registry;

import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;

public class BlockRegistryObjectGroup<B extends Block, I extends Item, T extends BlockEntity>
implements Supplier<B> {
    private final String name;
    private final Supplier<B> blockCreator;
    private final Function<B, I> itemCreator;
    private final BlockEntityType.BlockEntitySupplier<T> tileSupplier;
    private RegistryObject<B> block;
    private RegistryObject<I> item;
    private RegistryObject<BlockEntityType<T>> tileEntity;

    public BlockRegistryObjectGroup(String name, Supplier<B> blockCreator, Function<B, I> itemCreator) {
        this(name, blockCreator, itemCreator, null);
    }

    public BlockRegistryObjectGroup(String name, Supplier<B> blockCreator, Function<B, I> itemCreator, final Supplier<T> tileSupplier) {
        this.name = name;
        this.blockCreator = blockCreator;
        this.itemCreator = itemCreator;
        this.tileSupplier = new BlockEntityType.BlockEntitySupplier<T>(){

            public T m_155267_(BlockPos p_155268_, BlockState p_155269_) {
                return (BlockEntity)tileSupplier.get();
            }
        };
    }

    @Nonnull
    public B getBlock() {
        return (B)((Block)Objects.requireNonNull(this.block).get());
    }

    @Nonnull
    public I getItem() {
        return (I)((Item)Objects.requireNonNull(this.item).get());
    }

    @Nonnull
    public BlockEntityType<T> getTileEntityType() {
        return (BlockEntityType)Objects.requireNonNull(this.tileEntity).get();
    }

    public BlockRegistryObjectGroup<B, I, ?> register(DeferredRegister<Block> blockRegistry, DeferredRegister<Item> itemRegistry) {
        this.block = blockRegistry.register(this.name, this.blockCreator);
        this.item = itemRegistry.register(this.name, () -> (Item)this.itemCreator.apply(this.getBlock()));
        return this;
    }

    public BlockRegistryObjectGroup<B, I, T> register(DeferredRegister<Block> blockRegistry, DeferredRegister<Item> itemRegistry, DeferredRegister<BlockEntityType<?>> tileEntityTypeRegistry) {
        this.register(blockRegistry, itemRegistry);
        if (this.tileSupplier != null) {
            this.tileEntity = tileEntityTypeRegistry.register(this.name, () -> BlockEntityType.Builder.m_155273_(this.tileSupplier, (Block[])new Block[]{this.getBlock()}).m_58966_(null));
        }
        return this;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public B get() {
        return this.getBlock();
    }
}

