/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.block_network.graph;

import com.hrznstudio.titanium.api.block_network.NetworkElement;
import com.hrznstudio.titanium.block_network.Network;
import com.hrznstudio.titanium.block_network.graph.NetworkGraphScanner;
import com.hrznstudio.titanium.block_network.graph.NetworkGraphScannerResult;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;

public class NetworkGraph {
    private final Network network;
    private Set<NetworkElement> elements = new HashSet<NetworkElement>();

    public NetworkGraph(Network network) {
        this.network = network;
    }

    public NetworkGraphScannerResult scan(Level originLevel, BlockPos originPos) {
        NetworkGraphScanner scanner = new NetworkGraphScanner(this.elements, this.network.getType());
        NetworkGraphScannerResult result = scanner.scanAt(originLevel, originPos);
        this.elements = result.getFoundElements();
        result.getNewElements().forEach(p -> p.joinNetwork(this.network));
        result.getRemovedElements().forEach(NetworkElement::leaveNetwork);
        return result;
    }

    public Set<NetworkElement> getElements() {
        return this.elements;
    }
}

