/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_core.client.util.combiner;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.valhelsia.valhelsia_core.client.util.combiner.BlockCombineResult;
import org.apache.commons.lang3.function.TriFunction;

public class BlockCombiner {
    public static final Map<Predicate<BlockState>, TriFunction<BlockAndTintGetter, BlockState, BlockPos, BlockCombineResult<BlockPos>>> BRIGHTNESS_COMBINERS = new HashMap<Predicate<BlockState>, TriFunction<BlockAndTintGetter, BlockState, BlockPos, BlockCombineResult<BlockPos>>>();

    public static void registerBrightnessCombiner(Predicate<BlockState> predicate, TriFunction<BlockAndTintGetter, BlockState, BlockPos, BlockCombineResult<BlockPos>> combineResult) {
        BRIGHTNESS_COMBINERS.put(predicate, combineResult);
    }

    public static <T> BlockCombineResult<T> combine(List<T> values) {
        return switch (values.size()) {
            case 1 -> new BlockCombineResult.Single<T>(values.get(0));
            case 2 -> new BlockCombineResult.Double<T>(values.get(0), values.get(1));
            default -> new BlockCombineResult.Multiple<T>(values);
        };
    }

    public static interface Combiner<S, T> {
        public T acceptSingle(S var1);

        public T acceptDouble(S var1, S var2);

        public T acceptMultiple(List<S> var1);
    }
}

