/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.util;

import dev.architectury.event.EventActor;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.client.ClientChatEvent;
import dev.ftb.mods.ftblibrary.FTBLibrary;
import dev.ftb.mods.ftblibrary.ui.BaseScreen;
import dev.ftb.mods.ftblibrary.ui.CustomClickEvent;
import dev.ftb.mods.ftblibrary.ui.IScreenWrapper;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class ClientUtils {
    public static final BooleanSupplier IS_CLIENT_OP = () -> Minecraft.m_91087_().f_91074_ != null && Minecraft.m_91087_().f_91074_.m_20310_(1);
    public static final List<Runnable> RUN_LATER = new ArrayList<Runnable>();
    private static final MethodType EMPTY_METHOD_TYPE = MethodType.methodType(Void.TYPE);
    private static final HashMap<String, Optional<MethodHandle>> staticMethodCache = new HashMap();

    public static void execClientCommand(String command, boolean printChat) {
        EventResult res;
        if (!command.isEmpty() && Minecraft.m_91087_().f_91074_ != null && !(res = ((ClientChatEvent.Send)ClientChatEvent.SEND.invoker()).send(command, null)).interruptsFurtherEvaluation()) {
            if (printChat) {
                Minecraft.m_91087_().f_91065_.m_93076_().m_93783_(command);
            }
            Minecraft.m_91087_().f_91074_.m_234148_(command.replace("/", ""), null);
        }
    }

    public static void runLater(Runnable runnable) {
        RUN_LATER.add(runnable);
    }

    @Nullable
    public static <T> T getGuiAs(Screen gui, Class<T> clazz) {
        BaseScreen guiBase;
        if (gui instanceof IScreenWrapper && clazz.isAssignableFrom((guiBase = ((IScreenWrapper)gui).getGui()).getClass())) {
            return (T)guiBase;
        }
        return (T)(clazz.isAssignableFrom(gui.getClass()) ? Minecraft.m_91087_().f_91080_ : null);
    }

    @Nullable
    public static <T> T getCurrentGuiAs(Class<T> clazz) {
        return Minecraft.m_91087_().f_91080_ == null ? null : (T)ClientUtils.getGuiAs(Minecraft.m_91087_().f_91080_, clazz);
    }

    public static boolean handleClick(String scheme, String path) {
        switch (scheme) {
            case "http": 
            case "https": {
                try {
                    URI uri = new URI(scheme + ":" + path);
                    if (((Boolean)Minecraft.m_91087_().f_91066_.m_231816_().m_231551_()).booleanValue()) {
                        Screen currentScreen = Minecraft.m_91087_().f_91080_;
                        Minecraft.m_91087_().m_91152_((Screen)new ConfirmLinkScreen(result -> {
                            if (result) {
                                try {
                                    Util.m_137581_().m_137648_(uri);
                                }
                                catch (Exception ex) {
                                    ex.printStackTrace();
                                }
                            }
                            Minecraft.m_91087_().m_91152_(currentScreen);
                        }, scheme + ":" + path, false));
                    } else {
                        Util.m_137581_().m_137648_(uri);
                    }
                    return true;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    return false;
                }
            }
            case "file": {
                try {
                    Util.m_137581_().m_137648_(new URI("file:" + path));
                    return true;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    return false;
                }
            }
            case "command": {
                ClientUtils.execClientCommand(path, false);
                return true;
            }
            case "static_method": {
                Optional<MethodHandle> handle = staticMethodCache.get(path);
                if (handle == null) {
                    handle = Optional.empty();
                    String[] s = path.split(":", 2);
                    try {
                        Class<?> c = Class.forName(s[0]);
                        MethodHandle h = MethodHandles.publicLookup().findStatic(c, s[1], EMPTY_METHOD_TYPE);
                        handle = Optional.ofNullable(h);
                    }
                    catch (Throwable ex) {
                        ex.printStackTrace();
                    }
                    staticMethodCache.put(path, handle);
                }
                if (handle.isPresent()) {
                    try {
                        handle.get().invoke();
                        return true;
                    }
                    catch (Throwable ex) {
                        ex.printStackTrace();
                    }
                }
                return false;
            }
            case "custom": {
                if (!ResourceLocation.m_135830_((String)path)) break;
                return ((EventActor)CustomClickEvent.EVENT.invoker()).act((Object)new CustomClickEvent(new ResourceLocation(path))).isPresent();
            }
        }
        if (ResourceLocation.m_135830_((String)(scheme + ":" + path))) {
            return ((EventActor)CustomClickEvent.EVENT.invoker()).act((Object)new CustomClickEvent(new ResourceLocation(scheme, path))).isPresent();
        }
        FTBLibrary.LOGGER.warn("invalid scheme/path resourcelocation for handleClick(): {}:{}", (Object)scheme, (Object)path);
        return false;
    }
}

