/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.outliner;

import com.jozufozu.flywheel.util.transform.TransformStack;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3d;
import com.mojang.math.Vector3f;
import com.mojang.math.Vector4f;
import com.simibubi.create.AllSpecialTextures;
import com.simibubi.create.foundation.render.SuperRenderTypeBuffer;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.Color;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;

public abstract class Outline {
    protected final OutlineParams params;
    protected final Vector4f colorTemp = new Vector4f();
    protected final Vector3f diffPosTemp = new Vector3f();
    protected final Vector3f minPosTemp = new Vector3f();
    protected final Vector3f maxPosTemp = new Vector3f();
    protected final Vector4f posTransformTemp = new Vector4f();
    protected final Vector3f normalTransformTemp = new Vector3f();

    public Outline() {
        this.params = new OutlineParams();
    }

    public OutlineParams getParams() {
        return this.params;
    }

    public abstract void render(PoseStack var1, SuperRenderTypeBuffer var2, Vec3 var3, float var4);

    public void tick() {
    }

    public void bufferCuboidLine(PoseStack poseStack, VertexConsumer consumer, Vec3 camera, Vector3d start, Vector3d end, float width, Vector4f color, int lightmap, boolean disableNormals) {
        Vector3f diff = this.diffPosTemp;
        diff.m_122245_((float)(end.f_86214_ - start.f_86214_), (float)(end.f_86215_ - start.f_86215_), (float)(end.f_86216_ - start.f_86216_));
        float length = Mth.m_14116_((float)(diff.m_122239_() * diff.m_122239_() + diff.m_122260_() * diff.m_122260_() + diff.m_122269_() * diff.m_122269_()));
        float hAngle = AngleHelper.deg(Mth.m_14136_((double)diff.m_122239_(), (double)diff.m_122269_()));
        float hDistance = Mth.m_14116_((float)(diff.m_122239_() * diff.m_122239_() + diff.m_122269_() * diff.m_122269_()));
        float vAngle = AngleHelper.deg(Mth.m_14136_((double)hDistance, (double)diff.m_122260_())) - 90.0f;
        poseStack.m_85836_();
        ((TransformStack)((TransformStack)TransformStack.cast((PoseStack)poseStack).translate(start.f_86214_ - camera.f_82479_, start.f_86215_ - camera.f_82480_, start.f_86216_ - camera.f_82481_)).rotateY((double)hAngle)).rotateX((double)vAngle);
        this.bufferCuboidLine(poseStack.m_85850_(), consumer, Vector3f.f_176763_, Direction.SOUTH, length, width, color, lightmap, disableNormals);
        poseStack.m_85849_();
    }

    public void bufferCuboidLine(PoseStack.Pose pose, VertexConsumer consumer, Vector3f origin, Direction direction, float length, float width, Vector4f color, int lightmap, boolean disableNormals) {
        Vector3f minPos = this.minPosTemp;
        Vector3f maxPos = this.maxPosTemp;
        float halfWidth = width / 2.0f;
        minPos.m_122245_(origin.m_122239_() - halfWidth, origin.m_122260_() - halfWidth, origin.m_122269_() - halfWidth);
        maxPos.m_122245_(origin.m_122239_() + halfWidth, origin.m_122260_() + halfWidth, origin.m_122269_() + halfWidth);
        switch (direction) {
            case DOWN: {
                minPos.m_122272_(0.0f, -length, 0.0f);
                break;
            }
            case UP: {
                maxPos.m_122272_(0.0f, length, 0.0f);
                break;
            }
            case NORTH: {
                minPos.m_122272_(0.0f, 0.0f, -length);
                break;
            }
            case SOUTH: {
                maxPos.m_122272_(0.0f, 0.0f, length);
                break;
            }
            case WEST: {
                minPos.m_122272_(-length, 0.0f, 0.0f);
                break;
            }
            case EAST: {
                maxPos.m_122272_(length, 0.0f, 0.0f);
            }
        }
        this.bufferCuboid(pose, consumer, minPos, maxPos, color, lightmap, disableNormals);
    }

    public void bufferCuboid(PoseStack.Pose pose, VertexConsumer consumer, Vector3f minPos, Vector3f maxPos, Vector4f color, int lightmap, boolean disableNormals) {
        Vector4f posTransformTemp = this.posTransformTemp;
        Vector3f normalTransformTemp = this.normalTransformTemp;
        float minX = minPos.m_122239_();
        float minY = minPos.m_122260_();
        float minZ = minPos.m_122269_();
        float maxX = maxPos.m_122239_();
        float maxY = maxPos.m_122260_();
        float maxZ = maxPos.m_122269_();
        Matrix4f posMatrix = pose.m_85861_();
        posTransformTemp.m_123602_(minX, minY, maxZ, 1.0f);
        posTransformTemp.m_123607_(posMatrix);
        double x0 = posTransformTemp.m_123601_();
        double y0 = posTransformTemp.m_123615_();
        double z0 = posTransformTemp.m_123616_();
        posTransformTemp.m_123602_(minX, minY, minZ, 1.0f);
        posTransformTemp.m_123607_(posMatrix);
        double x1 = posTransformTemp.m_123601_();
        double y1 = posTransformTemp.m_123615_();
        double z1 = posTransformTemp.m_123616_();
        posTransformTemp.m_123602_(maxX, minY, minZ, 1.0f);
        posTransformTemp.m_123607_(posMatrix);
        double x2 = posTransformTemp.m_123601_();
        double y2 = posTransformTemp.m_123615_();
        double z2 = posTransformTemp.m_123616_();
        posTransformTemp.m_123602_(maxX, minY, maxZ, 1.0f);
        posTransformTemp.m_123607_(posMatrix);
        double x3 = posTransformTemp.m_123601_();
        double y3 = posTransformTemp.m_123615_();
        double z3 = posTransformTemp.m_123616_();
        posTransformTemp.m_123602_(minX, maxY, minZ, 1.0f);
        posTransformTemp.m_123607_(posMatrix);
        double x4 = posTransformTemp.m_123601_();
        double y4 = posTransformTemp.m_123615_();
        double z4 = posTransformTemp.m_123616_();
        posTransformTemp.m_123602_(minX, maxY, maxZ, 1.0f);
        posTransformTemp.m_123607_(posMatrix);
        double x5 = posTransformTemp.m_123601_();
        double y5 = posTransformTemp.m_123615_();
        double z5 = posTransformTemp.m_123616_();
        posTransformTemp.m_123602_(maxX, maxY, maxZ, 1.0f);
        posTransformTemp.m_123607_(posMatrix);
        double x6 = posTransformTemp.m_123601_();
        double y6 = posTransformTemp.m_123615_();
        double z6 = posTransformTemp.m_123616_();
        posTransformTemp.m_123602_(maxX, maxY, minZ, 1.0f);
        posTransformTemp.m_123607_(posMatrix);
        double x7 = posTransformTemp.m_123601_();
        double y7 = posTransformTemp.m_123615_();
        double z7 = posTransformTemp.m_123616_();
        float r = color.m_123601_();
        float g = color.m_123615_();
        float b = color.m_123616_();
        float a = color.m_123617_();
        Matrix3f normalMatrix = pose.m_85864_();
        if (disableNormals) {
            normalTransformTemp.m_122245_(0.0f, 1.0f, 0.0f);
        } else {
            normalTransformTemp.m_122245_(0.0f, -1.0f, 0.0f);
        }
        normalTransformTemp.m_122249_(normalMatrix);
        float nx0 = normalTransformTemp.m_122239_();
        float ny0 = normalTransformTemp.m_122260_();
        float nz0 = normalTransformTemp.m_122269_();
        consumer.m_5483_(x0, y0, z0).m_85950_(r, g, b, a).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(lightmap).m_5601_(nx0, ny0, nz0).m_5752_();
        consumer.m_5483_(x1, y1, z1).m_85950_(r, g, b, a).m_7421_(0.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(lightmap).m_5601_(nx0, ny0, nz0).m_5752_();
        consumer.m_5483_(x2, y2, z2).m_85950_(r, g, b, a).m_7421_(1.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(lightmap).m_5601_(nx0, ny0, nz0).m_5752_();
        consumer.m_5483_(x3, y3, z3).m_85950_(r, g, b, a).m_7421_(1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(lightmap).m_5601_(nx0, ny0, nz0).m_5752_();
        normalTransformTemp.m_122245_(0.0f, 1.0f, 0.0f);
        normalTransformTemp.m_122249_(normalMatrix);
        float nx1 = normalTransformTemp.m_122239_();
        float ny1 = normalTransformTemp.m_122260_();
        float nz1 = normalTransformTemp.m_122269_();
        consumer.m_5483_(x4, y4, z4).m_85950_(r, g, b, a).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(lightmap).m_5601_(nx1, ny1, nz1).m_5752_();
        consumer.m_5483_(x5, y5, z5).m_85950_(r, g, b, a).m_7421_(0.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(lightmap).m_5601_(nx1, ny1, nz1).m_5752_();
        consumer.m_5483_(x6, y6, z6).m_85950_(r, g, b, a).m_7421_(1.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(lightmap).m_5601_(nx1, ny1, nz1).m_5752_();
        consumer.m_5483_(x7, y7, z7).m_85950_(r, g, b, a).m_7421_(1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(lightmap).m_5601_(nx1, ny1, nz1).m_5752_();
        if (disableNormals) {
            normalTransformTemp.m_122245_(0.0f, 1.0f, 0.0f);
        } else {
            normalTransformTemp.m_122245_(0.0f, 0.0f, -1.0f);
        }
        normalTransformTemp.m_122249_(normalMatrix);
        float nx2 = normalTransformTemp.m_122239_();
        float ny2 = normalTransformTemp.m_122260_();
        float nz2 = normalTransformTemp.m_122269_();
        consumer.m_5483_(x7, y7, z7).m_85950_(r, g, b, a).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(lightmap).m_5601_(nx2, ny2, nz2).m_5752_();
        consumer.m_5483_(x2, y2, z2).m_85950_(r, g, b, a).m_7421_(0.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(lightmap).m_5601_(nx2, ny2, nz2).m_5752_();
        consumer.m_5483_(x1, y1, z1).m_85950_(r, g, b, a).m_7421_(1.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(lightmap).m_5601_(nx2, ny2, nz2).m_5752_();
        consumer.m_5483_(x4, y4, z4).m_85950_(r, g, b, a).m_7421_(1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(lightmap).m_5601_(nx2, ny2, nz2).m_5752_();
        if (disableNormals) {
            normalTransformTemp.m_122245_(0.0f, 1.0f, 0.0f);
        } else {
            normalTransformTemp.m_122245_(0.0f, 0.0f, 1.0f);
        }
        normalTransformTemp.m_122249_(normalMatrix);
        float nx3 = normalTransformTemp.m_122239_();
        float ny3 = normalTransformTemp.m_122260_();
        float nz3 = normalTransformTemp.m_122269_();
        consumer.m_5483_(x5, y5, z5).m_85950_(r, g, b, a).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(lightmap).m_5601_(nx3, ny3, nz3).m_5752_();
        consumer.m_5483_(x0, y0, z0).m_85950_(r, g, b, a).m_7421_(0.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(lightmap).m_5601_(nx3, ny3, nz3).m_5752_();
        consumer.m_5483_(x3, y3, z3).m_85950_(r, g, b, a).m_7421_(1.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(lightmap).m_5601_(nx3, ny3, nz3).m_5752_();
        consumer.m_5483_(x6, y6, z6).m_85950_(r, g, b, a).m_7421_(1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(lightmap).m_5601_(nx3, ny3, nz3).m_5752_();
        if (disableNormals) {
            normalTransformTemp.m_122245_(0.0f, 1.0f, 0.0f);
        } else {
            normalTransformTemp.m_122245_(-1.0f, 0.0f, 0.0f);
        }
        normalTransformTemp.m_122249_(normalMatrix);
        float nx4 = normalTransformTemp.m_122239_();
        float ny4 = normalTransformTemp.m_122260_();
        float nz4 = normalTransformTemp.m_122269_();
        consumer.m_5483_(x4, y4, z4).m_85950_(r, g, b, a).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(lightmap).m_5601_(nx4, ny4, nz4).m_5752_();
        consumer.m_5483_(x1, y1, z1).m_85950_(r, g, b, a).m_7421_(0.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(lightmap).m_5601_(nx4, ny4, nz4).m_5752_();
        consumer.m_5483_(x0, y0, z0).m_85950_(r, g, b, a).m_7421_(1.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(lightmap).m_5601_(nx4, ny4, nz4).m_5752_();
        consumer.m_5483_(x5, y5, z5).m_85950_(r, g, b, a).m_7421_(1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(lightmap).m_5601_(nx4, ny4, nz4).m_5752_();
        if (disableNormals) {
            normalTransformTemp.m_122245_(0.0f, 1.0f, 0.0f);
        } else {
            normalTransformTemp.m_122245_(1.0f, 0.0f, 0.0f);
        }
        normalTransformTemp.m_122249_(normalMatrix);
        float nx5 = normalTransformTemp.m_122239_();
        float ny5 = normalTransformTemp.m_122260_();
        float nz5 = normalTransformTemp.m_122269_();
        consumer.m_5483_(x6, y6, z6).m_85950_(r, g, b, a).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(lightmap).m_5601_(nx5, ny5, nz5).m_5752_();
        consumer.m_5483_(x3, y3, z3).m_85950_(r, g, b, a).m_7421_(0.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(lightmap).m_5601_(nx5, ny5, nz5).m_5752_();
        consumer.m_5483_(x2, y2, z2).m_85950_(r, g, b, a).m_7421_(1.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(lightmap).m_5601_(nx5, ny5, nz5).m_5752_();
        consumer.m_5483_(x7, y7, z7).m_85950_(r, g, b, a).m_7421_(1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(lightmap).m_5601_(nx5, ny5, nz5).m_5752_();
    }

    public void bufferQuad(PoseStack.Pose pose, VertexConsumer consumer, Vector3f pos0, Vector3f pos1, Vector3f pos2, Vector3f pos3, Vector4f color, int lightmap, Vector3f normal) {
        this.bufferQuad(pose, consumer, pos0, pos1, pos2, pos3, color, 0.0f, 0.0f, 1.0f, 1.0f, lightmap, normal);
    }

    public void bufferQuad(PoseStack.Pose pose, VertexConsumer consumer, Vector3f pos0, Vector3f pos1, Vector3f pos2, Vector3f pos3, Vector4f color, float minU, float minV, float maxU, float maxV, int lightmap, Vector3f normal) {
        Vector4f posTransformTemp = this.posTransformTemp;
        Vector3f normalTransformTemp = this.normalTransformTemp;
        Matrix4f posMatrix = pose.m_85861_();
        posTransformTemp.m_123602_(pos0.m_122239_(), pos0.m_122260_(), pos0.m_122269_(), 1.0f);
        posTransformTemp.m_123607_(posMatrix);
        double x0 = posTransformTemp.m_123601_();
        double y0 = posTransformTemp.m_123615_();
        double z0 = posTransformTemp.m_123616_();
        posTransformTemp.m_123602_(pos1.m_122239_(), pos1.m_122260_(), pos1.m_122269_(), 1.0f);
        posTransformTemp.m_123607_(posMatrix);
        double x1 = posTransformTemp.m_123601_();
        double y1 = posTransformTemp.m_123615_();
        double z1 = posTransformTemp.m_123616_();
        posTransformTemp.m_123602_(pos2.m_122239_(), pos2.m_122260_(), pos2.m_122269_(), 1.0f);
        posTransformTemp.m_123607_(posMatrix);
        double x2 = posTransformTemp.m_123601_();
        double y2 = posTransformTemp.m_123615_();
        double z2 = posTransformTemp.m_123616_();
        posTransformTemp.m_123602_(pos3.m_122239_(), pos3.m_122260_(), pos3.m_122269_(), 1.0f);
        posTransformTemp.m_123607_(posMatrix);
        double x3 = posTransformTemp.m_123601_();
        double y3 = posTransformTemp.m_123615_();
        double z3 = posTransformTemp.m_123616_();
        float r = color.m_123601_();
        float g = color.m_123615_();
        float b = color.m_123616_();
        float a = color.m_123617_();
        normalTransformTemp.m_176768_(normal);
        normalTransformTemp.m_122249_(pose.m_85864_());
        float nx = normalTransformTemp.m_122239_();
        float ny = normalTransformTemp.m_122260_();
        float nz = normalTransformTemp.m_122269_();
        consumer.m_5483_(x0, y0, z0).m_85950_(r, g, b, a).m_7421_(minU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(lightmap).m_5601_(nx, ny, nz).m_5752_();
        consumer.m_5483_(x1, y1, z1).m_85950_(r, g, b, a).m_7421_(minU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(lightmap).m_5601_(nx, ny, nz).m_5752_();
        consumer.m_5483_(x2, y2, z2).m_85950_(r, g, b, a).m_7421_(maxU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(lightmap).m_5601_(nx, ny, nz).m_5752_();
        consumer.m_5483_(x3, y3, z3).m_85950_(r, g, b, a).m_7421_(maxU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(lightmap).m_5601_(nx, ny, nz).m_5752_();
    }

    public static class OutlineParams {
        protected Optional<AllSpecialTextures> faceTexture;
        protected Optional<AllSpecialTextures> hightlightedFaceTexture = Optional.empty();
        protected Direction highlightedFace;
        protected boolean fadeLineWidth = true;
        protected boolean disableCull;
        protected boolean disableLineNormals;
        protected float alpha = 1.0f;
        protected int lightmap = 0xF000F0;
        protected Color rgb;
        private float lineWidth = 0.03125f;

        public OutlineParams() {
            this.faceTexture = this.hightlightedFaceTexture;
            this.rgb = Color.WHITE;
        }

        public OutlineParams colored(int color) {
            this.rgb = new Color(color, false);
            return this;
        }

        public OutlineParams colored(Color c) {
            this.rgb = c.copy();
            return this;
        }

        public OutlineParams lightmap(int light) {
            this.lightmap = light;
            return this;
        }

        public OutlineParams lineWidth(float width) {
            this.lineWidth = width;
            return this;
        }

        public OutlineParams withFaceTexture(AllSpecialTextures texture) {
            this.faceTexture = Optional.ofNullable(texture);
            return this;
        }

        public OutlineParams clearTextures() {
            return this.withFaceTextures(null, null);
        }

        public OutlineParams withFaceTextures(AllSpecialTextures texture, AllSpecialTextures highlightTexture) {
            this.faceTexture = Optional.ofNullable(texture);
            this.hightlightedFaceTexture = Optional.ofNullable(highlightTexture);
            return this;
        }

        public OutlineParams highlightFace(@Nullable Direction face) {
            this.highlightedFace = face;
            return this;
        }

        public OutlineParams disableLineNormals() {
            this.disableLineNormals = true;
            return this;
        }

        public OutlineParams disableCull() {
            this.disableCull = true;
            return this;
        }

        public float getLineWidth() {
            return this.fadeLineWidth ? this.alpha * this.lineWidth : this.lineWidth;
        }

        public Direction getHighlightedFace() {
            return this.highlightedFace;
        }

        public void loadColor(Vector4f vec) {
            vec.m_123602_(this.rgb.getRedAsFloat(), this.rgb.getGreenAsFloat(), this.rgb.getBlueAsFloat(), this.rgb.getAlphaAsFloat() * this.alpha);
        }
    }
}

