/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.gui;

import com.simibubi.create.foundation.ponder.ui.NavigatableSimiScreen;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;

public class ScreenOpener {
    private static final Deque<Screen> backStack = new ArrayDeque<Screen>();
    private static Screen backSteppedFrom = null;

    public static void open(Screen screen) {
        ScreenOpener.open(Minecraft.m_91087_().f_91080_, screen);
    }

    public static void open(@Nullable Screen current, Screen toOpen) {
        backSteppedFrom = null;
        if (current != null) {
            if (backStack.size() >= 15) {
                backStack.pollLast();
            }
            backStack.push(current);
        } else {
            backStack.clear();
        }
        ScreenOpener.openScreen(toOpen);
    }

    public static void openPreviousScreen(Screen current, Optional<NavigatableSimiScreen> screenWithContext) {
        if (backStack.isEmpty()) {
            return;
        }
        backSteppedFrom = current;
        Screen previousScreen = backStack.pop();
        if (previousScreen instanceof NavigatableSimiScreen) {
            NavigatableSimiScreen previousAbstractSimiScreen = (NavigatableSimiScreen)previousScreen;
            screenWithContext.ifPresent(s -> s.shareContextWith(previousAbstractSimiScreen));
            previousAbstractSimiScreen.transition.startWithValue(-0.1).chase(-1.0, 0.4f, LerpedFloat.Chaser.EXP);
        }
        ScreenOpener.openScreen(previousScreen);
    }

    public static void transitionTo(NavigatableSimiScreen screen) {
        if (ScreenOpener.tryBackTracking(screen)) {
            return;
        }
        screen.transition.startWithValue(0.1).chase(1.0, 0.4f, LerpedFloat.Chaser.EXP);
        ScreenOpener.open(screen);
    }

    private static boolean tryBackTracking(NavigatableSimiScreen screen) {
        List<Screen> screenHistory = ScreenOpener.getScreenHistory();
        if (screenHistory.isEmpty()) {
            return false;
        }
        Screen previouslyRenderedScreen = screenHistory.get(0);
        if (!(previouslyRenderedScreen instanceof NavigatableSimiScreen)) {
            return false;
        }
        if (!screen.isEquivalentTo((NavigatableSimiScreen)previouslyRenderedScreen)) {
            return false;
        }
        ScreenOpener.openPreviousScreen(Minecraft.m_91087_().f_91080_, Optional.of(screen));
        return true;
    }

    public static void clearStack() {
        backStack.clear();
    }

    public static List<Screen> getScreenHistory() {
        return new ArrayList<Screen>(backStack);
    }

    @Nullable
    public static Screen getPreviouslyRenderedScreen() {
        return backSteppedFrom != null ? backSteppedFrom : backStack.peek();
    }

    private static void openScreen(Screen screen) {
        Minecraft.m_91087_().m_6937_(() -> {
            Minecraft.m_91087_().m_91152_(screen);
            Screen previouslyRenderedScreen = ScreenOpener.getPreviouslyRenderedScreen();
            if (previouslyRenderedScreen != null && screen instanceof NavigatableSimiScreen) {
                previouslyRenderedScreen.m_6575_(Minecraft.m_91087_(), screen.f_96543_, screen.f_96544_);
            }
        });
    }
}

