/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.trains.station;

import com.jozufozu.flywheel.core.PartialModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllPackets;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.contraptions.AssemblyException;
import com.simibubi.create.content.trains.entity.Carriage;
import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.entity.TrainIconType;
import com.simibubi.create.content.trains.station.AbstractStationScreen;
import com.simibubi.create.content.trains.station.GlobalStation;
import com.simibubi.create.content.trains.station.StationBlockEntity;
import com.simibubi.create.content.trains.station.StationEditPacket;
import com.simibubi.create.content.trains.station.StationScreen;
import com.simibubi.create.content.trains.station.TrainEditPacket;
import com.simibubi.create.content.trains.station.WideIconButton;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollValueBehaviour;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.widget.IconButton;
import com.simibubi.create.foundation.gui.widget.ScrollInput;
import com.simibubi.create.foundation.utility.Lang;
import java.lang.ref.WeakReference;
import java.util.List;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class AssemblyScreen
extends AbstractStationScreen {
    private IconButton quitAssembly;
    private IconButton toggleAssemblyButton;
    private List<ResourceLocation> iconTypes;
    private ScrollInput iconTypeScroll;

    public AssemblyScreen(StationBlockEntity be, GlobalStation station) {
        super(be, station);
        this.background = AllGuiTextures.STATION_ASSEMBLING;
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        int x = this.guiLeft;
        int y = this.guiTop;
        int by = y + this.background.height - 24;
        Widget widget = (Widget)this.f_169369_.get(0);
        if (widget instanceof IconButton) {
            IconButton ib = (IconButton)widget;
            ib.setIcon(AllIcons.I_PRIORITY_VERY_LOW);
            ib.setToolTip((Component)Lang.translateDirect("station.close", new Object[0]));
        }
        this.iconTypes = TrainIconType.REGISTRY.keySet().stream().toList();
        this.iconTypeScroll = new ScrollInput(x + 4, y + 17, 184, 14).titled(Lang.translateDirect("station.icon_type", new Object[0]));
        this.iconTypeScroll.withRange(0, this.iconTypes.size());
        this.iconTypeScroll.withStepFunction(ctx -> -this.iconTypeScroll.standardStep().apply((ScrollValueBehaviour.StepContext)ctx).intValue());
        this.iconTypeScroll.calling(s -> {
            Train train = (Train)this.displayedTrain.get();
            if (train != null) {
                train.icon = TrainIconType.byId(this.iconTypes.get((int)s));
            }
        });
        this.iconTypeScroll.f_93624_ = false;
        this.iconTypeScroll.f_93623_ = false;
        this.m_142416_(this.iconTypeScroll);
        this.toggleAssemblyButton = new WideIconButton(x + 94, by, AllGuiTextures.I_ASSEMBLE_TRAIN);
        this.toggleAssemblyButton.f_93623_ = false;
        this.toggleAssemblyButton.setToolTip((Component)Lang.translateDirect("station.assemble_train", new Object[0]));
        this.toggleAssemblyButton.withCallback(() -> AllPackets.getChannel().sendToServer((Object)StationEditPacket.tryAssemble(this.blockEntity.m_58899_())));
        this.quitAssembly = new IconButton(x + 73, by, AllIcons.I_DISABLE);
        this.quitAssembly.f_93623_ = true;
        this.quitAssembly.setToolTip((Component)Lang.translateDirect("station.cancel", new Object[0]));
        this.quitAssembly.withCallback(() -> {
            AllPackets.getChannel().sendToServer((Object)StationEditPacket.configure(this.blockEntity.m_58899_(), false, this.station.name, null));
            this.f_96541_.m_91152_((Screen)new StationScreen(this.blockEntity, this.station));
        });
        this.m_142416_(this.toggleAssemblyButton);
        this.m_142416_(this.quitAssembly);
        this.tickTrainDisplay();
    }

    @Override
    public void m_86600_() {
        super.m_86600_();
        this.tickTrainDisplay();
        Train train = (Train)this.displayedTrain.get();
        boolean bl = this.toggleAssemblyButton.f_93623_ = this.blockEntity.bogeyCount > 0 || train != null;
        if (train != null) {
            AllPackets.getChannel().sendToServer((Object)StationEditPacket.configure(this.blockEntity.m_58899_(), false, this.station.name, null));
            this.f_96541_.m_91152_((Screen)new StationScreen(this.blockEntity, this.station));
            for (Carriage carriage : train.carriages) {
                carriage.updateConductors();
            }
        }
    }

    private void tickTrainDisplay() {
        if (this.getImminent() == null) {
            this.displayedTrain = new WeakReference<Object>(null);
            this.quitAssembly.f_93623_ = true;
            this.iconTypeScroll.f_93624_ = false;
            this.iconTypeScroll.f_93623_ = false;
            this.toggleAssemblyButton.setToolTip((Component)Lang.translateDirect("station.assemble_train", new Object[0]));
            this.toggleAssemblyButton.setIcon(AllGuiTextures.I_ASSEMBLE_TRAIN);
            this.toggleAssemblyButton.withCallback(() -> AllPackets.getChannel().sendToServer((Object)StationEditPacket.tryAssemble(this.blockEntity.m_58899_())));
        } else {
            AllPackets.getChannel().sendToServer((Object)StationEditPacket.configure(this.blockEntity.m_58899_(), false, this.station.name, null));
            this.f_96541_.m_91152_((Screen)new StationScreen(this.blockEntity, this.station));
        }
    }

    @Override
    protected void renderWindow(PoseStack ms, int mouseX, int mouseY, float partialTicks) {
        super.renderWindow(ms, mouseX, mouseY, partialTicks);
        int x = this.guiLeft;
        int y = this.guiTop;
        MutableComponent header = Lang.translateDirect("station.assembly_title", new Object[0]);
        this.f_96547_.m_92889_(ms, (Component)header, (float)(x + this.background.width / 2 - this.f_96547_.m_92852_((FormattedText)header) / 2), (float)(y + 4), 926259);
        AssemblyException lastAssemblyException = this.blockEntity.lastException;
        if (lastAssemblyException != null) {
            MutableComponent text = Lang.translateDirect("station.failed", new Object[0]);
            this.f_96547_.m_92889_(ms, (Component)text, (float)(x + 97 - this.f_96547_.m_92852_((FormattedText)text) / 2), (float)(y + 47), 0x775B5B);
            int offset = 0;
            if (this.blockEntity.failedCarriageIndex != -1) {
                this.f_96547_.m_92889_(ms, (Component)Lang.translateDirect("station.carriage_number", this.blockEntity.failedCarriageIndex), (float)(x + 30), (float)(y + 67), 0x7A7A7A);
                offset += 10;
            }
            this.f_96547_.m_92857_((FormattedText)lastAssemblyException.component, x + 30, y + 67 + offset, 134, 0x775B5B);
            this.f_96547_.m_92857_((FormattedText)Lang.translateDirect("station.retry", new Object[0]), x + 30, y + 67 + (offset += this.f_96547_.m_92923_((FormattedText)lastAssemblyException.component, 134).size() * 9 + 5), 134, 0x7A7A7A);
            return;
        }
        int bogeyCount = this.blockEntity.bogeyCount;
        MutableComponent text = Lang.translateDirect(bogeyCount == 0 ? "station.no_bogeys" : (bogeyCount == 1 ? "station.one_bogey" : "station.more_bogeys"), bogeyCount);
        this.f_96547_.m_92889_(ms, (Component)text, (float)(x + 97 - this.f_96547_.m_92852_((FormattedText)text) / 2), (float)(y + 47), 0x7A7A7A);
        this.f_96547_.m_92857_((FormattedText)Lang.translateDirect("station.how_to", new Object[0]), x + 28, y + 62, 134, 0x7A7A7A);
        this.f_96547_.m_92857_((FormattedText)Lang.translateDirect("station.how_to_1", new Object[0]), x + 28, y + 94, 134, 0x7A7A7A);
        this.f_96547_.m_92857_((FormattedText)Lang.translateDirect("station.how_to_2", new Object[0]), x + 28, y + 117, 138, 0x7A7A7A);
    }

    public void m_7861_() {
        super.m_7861_();
        Train train = (Train)this.displayedTrain.get();
        if (train != null) {
            ResourceLocation iconId = this.iconTypes.get(this.iconTypeScroll.getState());
            train.icon = TrainIconType.byId(iconId);
            AllPackets.getChannel().sendToServer((Object)new TrainEditPacket(train.id, "", iconId));
        }
    }

    @Override
    protected PartialModel getFlag(float partialTicks) {
        return AllPartialModels.STATION_ASSEMBLE;
    }
}

