/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.schematics.client;

import com.simibubi.create.AllItems;
import com.simibubi.create.AllKeys;
import com.simibubi.create.AllPackets;
import com.simibubi.create.AllSpecialTextures;
import com.simibubi.create.Create;
import com.simibubi.create.CreateClient;
import com.simibubi.create.content.schematics.SchematicExport;
import com.simibubi.create.content.schematics.client.ClientSchematicLoader;
import com.simibubi.create.content.schematics.client.SchematicPromptScreen;
import com.simibubi.create.content.schematics.packet.InstantSchematicPacket;
import com.simibubi.create.foundation.gui.ScreenOpener;
import com.simibubi.create.foundation.outliner.Outliner;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.RaycastHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class SchematicAndQuillHandler {
    private Object outlineSlot = new Object();
    public BlockPos firstPos;
    public BlockPos secondPos;
    private BlockPos selectedPos;
    private Direction selectedFace;
    private int range = 10;

    public boolean mouseScrolled(double delta) {
        if (!this.isActive()) {
            return false;
        }
        if (!AllKeys.ctrlDown()) {
            return false;
        }
        if (this.secondPos == null) {
            this.range = (int)Mth.m_14008_((double)((double)this.range + delta), (double)1.0, (double)100.0);
        }
        if (this.selectedFace == null) {
            return true;
        }
        AABB bb = new AABB(this.firstPos, this.secondPos);
        Vec3i vec = this.selectedFace.m_122436_();
        Vec3 projectedView = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
        if (bb.m_82390_(projectedView)) {
            delta *= -1.0;
        }
        int x = (int)((double)vec.m_123341_() * delta);
        int y = (int)((double)vec.m_123342_() * delta);
        int z = (int)((double)vec.m_123343_() * delta);
        Direction.AxisDirection axisDirection = this.selectedFace.m_122421_();
        if (axisDirection == Direction.AxisDirection.NEGATIVE) {
            bb = bb.m_82386_((double)(-x), (double)(-y), (double)(-z));
        }
        double maxX = Math.max(bb.f_82291_ - (double)(x * axisDirection.m_122540_()), bb.f_82288_);
        double maxY = Math.max(bb.f_82292_ - (double)(y * axisDirection.m_122540_()), bb.f_82289_);
        double maxZ = Math.max(bb.f_82293_ - (double)(z * axisDirection.m_122540_()), bb.f_82290_);
        bb = new AABB(bb.f_82288_, bb.f_82289_, bb.f_82290_, maxX, maxY, maxZ);
        this.firstPos = new BlockPos(bb.f_82288_, bb.f_82289_, bb.f_82290_);
        this.secondPos = new BlockPos(bb.f_82291_, bb.f_82292_, bb.f_82293_);
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        Lang.translate("schematicAndQuill.dimensions", (int)bb.m_82362_() + 1, (int)bb.m_82376_() + 1, (int)bb.m_82385_() + 1).sendStatus((Player)player);
        return true;
    }

    public boolean onMouseInput(int button, boolean pressed) {
        if (!pressed || button != 1) {
            return false;
        }
        if (!this.isActive()) {
            return false;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player.m_6144_()) {
            this.discard();
            return true;
        }
        if (this.secondPos != null) {
            ScreenOpener.open(new SchematicPromptScreen());
            return true;
        }
        if (this.selectedPos == null) {
            Lang.translate("schematicAndQuill.noTarget", new Object[0]).sendStatus((Player)player);
            return true;
        }
        if (this.firstPos != null) {
            this.secondPos = this.selectedPos;
            Lang.translate("schematicAndQuill.secondPos", new Object[0]).sendStatus((Player)player);
            return true;
        }
        this.firstPos = this.selectedPos;
        Lang.translate("schematicAndQuill.firstPos", new Object[0]).sendStatus((Player)player);
        return true;
    }

    public void discard() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        this.firstPos = null;
        this.secondPos = null;
        Lang.translate("schematicAndQuill.abort", new Object[0]).sendStatus((Player)player);
    }

    public void tick() {
        AABB currentSelectionBox;
        if (!this.isActive()) {
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (AllKeys.ACTIVATE_TOOL.isPressed()) {
            float pt = AnimationTickHolder.getPartialTicks();
            Vec3 targetVec = player.m_20299_(pt).m_82549_(player.m_20154_().m_82490_((double)this.range));
            this.selectedPos = new BlockPos(targetVec);
        } else {
            BlockHitResult trace = RaycastHelper.rayTraceRange(player.f_19853_, (Player)player, 75.0);
            if (trace != null && trace.m_6662_() == HitResult.Type.BLOCK) {
                BlockPos hit = trace.m_82425_();
                boolean replaceable = player.f_19853_.m_8055_(hit).m_60629_(new BlockPlaceContext(new UseOnContext((Player)player, InteractionHand.MAIN_HAND, trace)));
                if (trace.m_82434_().m_122434_().m_122478_() && !replaceable) {
                    hit = hit.m_121945_(trace.m_82434_());
                }
                this.selectedPos = hit;
            } else {
                this.selectedPos = null;
            }
        }
        this.selectedFace = null;
        if (this.secondPos != null) {
            Vec3 projectedView;
            AABB bb = new AABB(this.firstPos, this.secondPos).m_82363_(1.0, 1.0, 1.0).m_82400_((double)0.45f);
            boolean inside = bb.m_82390_(projectedView = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_());
            RaycastHelper.PredicateTraceResult result = RaycastHelper.rayTraceUntil((Player)player, 70.0, pos -> inside ^ bb.m_82390_(VecHelper.getCenterOf((Vec3i)pos)));
            Direction direction = result.missed() ? null : (this.selectedFace = inside ? result.getFacing().m_122424_() : result.getFacing());
        }
        if ((currentSelectionBox = this.getCurrentSelectionBox()) != null) {
            this.outliner().chaseAABB(this.outlineSlot, currentSelectionBox).colored(6850245).withFaceTextures(AllSpecialTextures.CHECKERED, AllSpecialTextures.HIGHLIGHT_CHECKERED).lineWidth(0.0625f).highlightFace(this.selectedFace);
        }
    }

    private AABB getCurrentSelectionBox() {
        if (this.secondPos == null) {
            if (this.firstPos == null) {
                return this.selectedPos == null ? null : new AABB(this.selectedPos);
            }
            return this.selectedPos == null ? new AABB(this.firstPos) : new AABB(this.firstPos, this.selectedPos).m_82363_(1.0, 1.0, 1.0);
        }
        return new AABB(this.firstPos, this.secondPos).m_82363_(1.0, 1.0, 1.0);
    }

    private boolean isActive() {
        return this.isPresent() && AllItems.SCHEMATIC_AND_QUILL.isIn(Minecraft.m_91087_().f_91074_.m_21205_());
    }

    private boolean isPresent() {
        return Minecraft.m_91087_() != null && Minecraft.m_91087_().f_91073_ != null && Minecraft.m_91087_().f_91080_ == null;
    }

    public void saveSchematic(String string, boolean convertImmediately) {
        SchematicExport.SchematicExportResult result = SchematicExport.saveSchematic(SchematicExport.SCHEMATICS, string, false, (Level)Minecraft.m_91087_().f_91073_, this.firstPos, this.secondPos);
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (result == null) {
            Lang.translate("schematicAndQuill.failed", new Object[0]).style(ChatFormatting.RED).sendStatus((Player)player);
            return;
        }
        Path file = result.file();
        Lang.translate("schematicAndQuill.saved", file.getFileName()).sendStatus((Player)player);
        this.firstPos = null;
        this.secondPos = null;
        if (!convertImmediately) {
            return;
        }
        try {
            if (!ClientSchematicLoader.validateSizeLimitation(Files.size(file))) {
                return;
            }
            AllPackets.getChannel().sendToServer((Object)new InstantSchematicPacket(result.fileName(), result.origin(), result.bounds()));
        }
        catch (IOException e) {
            Create.LOGGER.error("Error instantly uploading Schematic file: " + file, (Throwable)e);
        }
    }

    private Outliner outliner() {
        return CreateClient.OUTLINER;
    }
}

