/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.kinetics.crusher;

import com.simibubi.create.AllBlockEntityTypes;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllShapes;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.RotatedPillarKineticBlock;
import com.simibubi.create.content.kinetics.crusher.CrushingWheelBlockEntity;
import com.simibubi.create.content.kinetics.crusher.CrushingWheelControllerBlock;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.utility.Iterate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CrushingWheelBlock
extends RotatedPillarKineticBlock
implements IBE<CrushingWheelBlockEntity> {
    public CrushingWheelBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    public Direction.Axis getRotationAxis(BlockState state) {
        return (Direction.Axis)state.m_61143_((Property)AXIS);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return AllShapes.CRUSHING_WHEEL_COLLISION_SHAPE;
    }

    @Override
    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        for (Direction d : Iterate.directions) {
            if (d.m_122434_() == state.m_61143_((Property)AXIS) || !AllBlocks.CRUSHING_WHEEL_CONTROLLER.has(worldIn.m_8055_(pos.m_121945_(d)))) continue;
            worldIn.m_7471_(pos.m_121945_(d), isMoving);
        }
        super.m_6810_(state, worldIn, pos, newState, isMoving);
    }

    public void updateControllers(BlockState state, Level world, BlockPos pos, Direction side) {
        if (side.m_122434_() == state.m_61143_((Property)AXIS)) {
            return;
        }
        if (world == null) {
            return;
        }
        BlockPos controllerPos = pos.m_121945_(side);
        BlockPos otherWheelPos = pos.m_5484_(side, 2);
        boolean controllerExists = AllBlocks.CRUSHING_WHEEL_CONTROLLER.has(world.m_8055_(controllerPos));
        boolean controllerIsValid = controllerExists && (Boolean)world.m_8055_(controllerPos).m_61143_((Property)CrushingWheelControllerBlock.VALID) != false;
        Direction controllerOldDirection = controllerExists ? (Direction)world.m_8055_(controllerPos).m_61143_((Property)CrushingWheelControllerBlock.f_52588_) : null;
        boolean controllerShouldExist = false;
        boolean controllerShouldBeValid = false;
        Direction controllerNewDirection = Direction.DOWN;
        BlockState otherState = world.m_8055_(otherWheelPos);
        if (AllBlocks.CRUSHING_WHEEL.has(otherState)) {
            controllerShouldExist = true;
            CrushingWheelBlockEntity be = (CrushingWheelBlockEntity)this.getBlockEntity((BlockGetter)world, pos);
            CrushingWheelBlockEntity otherBE = (CrushingWheelBlockEntity)this.getBlockEntity((BlockGetter)world, otherWheelPos);
            if (be != null && otherBE != null && be.getSpeed() > 0.0f != otherBE.getSpeed() > 0.0f && be.getSpeed() != 0.0f) {
                Direction.Axis wheelAxis = (Direction.Axis)state.m_61143_((Property)AXIS);
                Direction.Axis sideAxis = side.m_122434_();
                int controllerADO = Math.round(Math.signum(be.getSpeed())) * side.m_122421_().m_122540_();
                Vec3 controllerDirVec = new Vec3(wheelAxis == Direction.Axis.X ? 1.0 : 0.0, wheelAxis == Direction.Axis.Y ? 1.0 : 0.0, wheelAxis == Direction.Axis.Z ? 1.0 : 0.0).m_82537_(new Vec3(sideAxis == Direction.Axis.X ? 1.0 : 0.0, sideAxis == Direction.Axis.Y ? 1.0 : 0.0, sideAxis == Direction.Axis.Z ? 1.0 : 0.0));
                controllerNewDirection = Direction.m_122366_((double)(controllerDirVec.f_82479_ * (double)controllerADO), (double)(controllerDirVec.f_82480_ * (double)controllerADO), (double)(controllerDirVec.f_82481_ * (double)controllerADO));
                controllerShouldBeValid = true;
            }
            if (otherState.m_61143_((Property)AXIS) != state.m_61143_((Property)AXIS)) {
                controllerShouldExist = false;
            }
        }
        if (!controllerShouldExist) {
            if (controllerExists) {
                world.m_46597_(controllerPos, Blocks.f_50016_.m_49966_());
            }
            return;
        }
        if (!controllerExists) {
            if (!world.m_8055_(controllerPos).m_60767_().m_76336_()) {
                return;
            }
            world.m_46597_(controllerPos, (BlockState)((BlockState)AllBlocks.CRUSHING_WHEEL_CONTROLLER.getDefaultState().m_61124_((Property)CrushingWheelControllerBlock.VALID, (Comparable)Boolean.valueOf(controllerShouldBeValid))).m_61124_((Property)CrushingWheelControllerBlock.f_52588_, (Comparable)controllerNewDirection));
        } else if (controllerIsValid != controllerShouldBeValid || controllerOldDirection != controllerNewDirection) {
            world.m_46597_(controllerPos, (BlockState)((BlockState)world.m_8055_(controllerPos).m_61124_((Property)CrushingWheelControllerBlock.VALID, (Comparable)Boolean.valueOf(controllerShouldBeValid))).m_61124_((Property)CrushingWheelControllerBlock.f_52588_, (Comparable)controllerNewDirection));
        }
        ((CrushingWheelControllerBlock)AllBlocks.CRUSHING_WHEEL_CONTROLLER.get()).updateSpeed(world.m_8055_(controllerPos), (LevelAccessor)world, controllerPos);
    }

    public void m_7892_(BlockState state, Level worldIn, BlockPos pos, Entity entityIn) {
        if (entityIn.m_20186_() < (double)((float)pos.m_123342_() + 1.25f) || !entityIn.m_20096_()) {
            return;
        }
        float speed = this.getBlockEntityOptional((BlockGetter)worldIn, pos).map(KineticBlockEntity::getSpeed).orElse(Float.valueOf(0.0f)).floatValue();
        double x = 0.0;
        double z = 0.0;
        if (state.m_61143_((Property)AXIS) == Direction.Axis.X) {
            z = speed / 20.0f;
            x += ((double)((float)pos.m_123341_() + 0.5f) - entityIn.m_20185_()) * (double)0.1f;
        }
        if (state.m_61143_((Property)AXIS) == Direction.Axis.Z) {
            x = speed / -20.0f;
            z += ((double)((float)pos.m_123343_() + 0.5f) - entityIn.m_20189_()) * (double)0.1f;
        }
        entityIn.m_20256_(entityIn.m_20184_().m_82520_(x, 0.0, z));
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        for (Direction direction : Iterate.directions) {
            BlockPos neighbourPos = pos.m_121945_(direction);
            BlockState neighbourState = worldIn.m_8055_(neighbourPos);
            Direction.Axis stateAxis = (Direction.Axis)state.m_61143_((Property)AXIS);
            if (AllBlocks.CRUSHING_WHEEL_CONTROLLER.has(neighbourState) && direction.m_122434_() != stateAxis) {
                return false;
            }
            if (!AllBlocks.CRUSHING_WHEEL.has(neighbourState) || neighbourState.m_61143_((Property)AXIS) == stateAxis && stateAxis == direction.m_122434_()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        return face.m_122434_() == state.m_61143_((Property)AXIS);
    }

    @Override
    public float getParticleTargetRadius() {
        return 1.125f;
    }

    @Override
    public float getParticleInitialRadius() {
        return 1.0f;
    }

    @Override
    public Class<CrushingWheelBlockEntity> getBlockEntityClass() {
        return CrushingWheelBlockEntity.class;
    }

    @Override
    public BlockEntityType<? extends CrushingWheelBlockEntity> getBlockEntityType() {
        return (BlockEntityType)AllBlockEntityTypes.CRUSHING_WHEEL.get();
    }
}

