/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.kinetics.crafter;

import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.core.PartialModel;
import com.jozufozu.flywheel.util.transform.TransformStack;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.AllSpriteShifts;
import com.simibubi.create.content.kinetics.base.HorizontalKineticBlock;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import com.simibubi.create.content.kinetics.crafter.MechanicalCrafterBlock;
import com.simibubi.create.content.kinetics.crafter.MechanicalCrafterBlockEntity;
import com.simibubi.create.content.kinetics.crafter.RecipeGridHandler;
import com.simibubi.create.foundation.blockEntity.renderer.SafeBlockEntityRenderer;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.Pointing;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class MechanicalCrafterRenderer
extends SafeBlockEntityRenderer<MechanicalCrafterBlockEntity> {
    public MechanicalCrafterRenderer(BlockEntityRendererProvider.Context context) {
    }

    @Override
    protected void renderSafe(MechanicalCrafterBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        ms.m_85836_();
        Direction facing = (Direction)be.m_58900_().m_61143_(HorizontalKineticBlock.HORIZONTAL_FACING);
        Vec3 vec = Vec3.m_82528_((Vec3i)facing.m_122436_()).m_82490_(0.58).m_82520_(0.5, 0.5, 0.5);
        if (be.phase == MechanicalCrafterBlockEntity.Phase.EXPORTING) {
            Direction targetDirection = MechanicalCrafterBlock.getTargetDirection(be.m_58900_());
            float progress = Mth.m_14036_((float)(((float)(1000 - be.countDown) + (float)be.getCountDownSpeed() * partialTicks) / 1000.0f), (float)0.0f, (float)1.0f);
            vec = vec.m_82549_(Vec3.m_82528_((Vec3i)targetDirection.m_122436_()).m_82490_((double)(progress * 0.75f)));
        }
        ms.m_85837_(vec.f_82479_, vec.f_82480_, vec.f_82481_);
        ms.m_85841_(0.5f, 0.5f, 0.5f);
        float yRot = AngleHelper.horizontalAngle(facing);
        ms.m_85845_(Vector3f.f_122225_.m_122240_(yRot));
        this.renderItems(be, partialTicks, ms, buffer, light, overlay);
        ms.m_85849_();
        this.renderFast(be, partialTicks, ms, buffer, light);
    }

    public void renderItems(MechanicalCrafterBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        if (be.phase == MechanicalCrafterBlockEntity.Phase.IDLE) {
            ItemStack stack2 = be.getInventory().m_8020_(0);
            if (!stack2.m_41619_()) {
                ms.m_85836_();
                ms.m_85837_(0.0, 0.0, -0.00390625);
                ms.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
                Minecraft.m_91087_().m_91291_().m_174269_(stack2, ItemTransforms.TransformType.FIXED, light, overlay, ms, buffer, 0);
                ms.m_85849_();
            }
        } else {
            RecipeGridHandler.GroupedItems items = be.groupedItems;
            float distance = 0.5f;
            ms.m_85836_();
            if (be.phase == MechanicalCrafterBlockEntity.Phase.CRAFTING) {
                items = be.groupedItemsBeforeCraft;
                items.calcStats();
                float progress = Mth.m_14036_((float)(((float)(2000 - be.countDown) + (float)be.getCountDownSpeed() * partialTicks) / 1000.0f), (float)0.0f, (float)1.0f);
                float earlyProgress = Mth.m_14036_((float)(progress * 2.0f), (float)0.0f, (float)1.0f);
                float lateProgress = Mth.m_14036_((float)(progress * 2.0f - 1.0f), (float)0.0f, (float)1.0f);
                ms.m_85841_(1.0f - lateProgress, 1.0f - lateProgress, 1.0f - lateProgress);
                Vec3 centering = new Vec3((double)((float)(-items.minX) + (float)(-items.width + 1) / 2.0f), (double)((float)(-items.minY) + (float)(-items.height + 1) / 2.0f), 0.0).m_82490_((double)earlyProgress);
                ms.m_85837_(centering.f_82479_ * 0.5, centering.f_82480_ * 0.5, 0.0);
                distance += (-4.0f * (progress - 0.5f) * (progress - 0.5f) + 1.0f) * 0.25f;
            }
            boolean onlyRenderFirst = be.phase == MechanicalCrafterBlockEntity.Phase.INSERTING || be.phase == MechanicalCrafterBlockEntity.Phase.CRAFTING && be.countDown < 1000;
            float spacing = distance;
            items.grid.forEach((pair, stack) -> {
                if (onlyRenderFirst && ((Integer)pair.getLeft() != 0 || (Integer)pair.getRight() != 0)) {
                    return;
                }
                ms.m_85836_();
                Integer x = (Integer)pair.getKey();
                Integer y = (Integer)pair.getValue();
                ms.m_85837_((double)((float)x.intValue() * spacing), (double)((float)y.intValue() * spacing), 0.0);
                int offset = 0;
                if (be.phase == MechanicalCrafterBlockEntity.Phase.EXPORTING && be.m_58900_().m_61138_(MechanicalCrafterBlock.POINTING)) {
                    Pointing value = (Pointing)((Object)((Object)be.m_58900_().m_61143_(MechanicalCrafterBlock.POINTING)));
                    offset = value == Pointing.UP ? -1 : (value == Pointing.LEFT ? 2 : (value == Pointing.RIGHT ? -2 : 1));
                }
                ((TransformStack)TransformStack.cast((PoseStack)ms).rotateY(180.0)).translate(0.0, 0.0, (double)((float)(x + y * 3 + offset * 9) / 1024.0f));
                Minecraft.m_91087_().m_91291_().m_174269_(stack, ItemTransforms.TransformType.FIXED, light, overlay, ms, buffer, 0);
                ms.m_85849_();
            });
            ms.m_85849_();
            if (be.phase == MechanicalCrafterBlockEntity.Phase.CRAFTING) {
                items = be.groupedItems;
                float progress = Mth.m_14036_((float)(((float)(1000 - be.countDown) + (float)be.getCountDownSpeed() * partialTicks) / 1000.0f), (float)0.0f, (float)1.0f);
                float earlyProgress = Mth.m_14036_((float)(progress * 2.0f), (float)0.0f, (float)1.0f);
                float lateProgress = Mth.m_14036_((float)(progress * 2.0f - 1.0f), (float)0.0f, (float)1.0f);
                ms.m_85845_(Vector3f.f_122227_.m_122240_(earlyProgress * 2.0f * 360.0f));
                float upScaling = earlyProgress * 1.125f;
                float downScaling = 1.0f + (1.0f - lateProgress) * 0.125f;
                ms.m_85841_(upScaling, upScaling, upScaling);
                ms.m_85841_(downScaling, downScaling, downScaling);
                items.grid.forEach((pair, stack) -> {
                    if ((Integer)pair.getLeft() != 0 || (Integer)pair.getRight() != 0) {
                        return;
                    }
                    ms.m_85836_();
                    ms.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
                    Minecraft.m_91087_().m_91291_().m_174269_(stack, ItemTransforms.TransformType.FIXED, light, overlay, ms, buffer, 0);
                    ms.m_85849_();
                });
            }
        }
    }

    public void renderFast(MechanicalCrafterBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light) {
        BlockState blockState = be.m_58900_();
        VertexConsumer vb = buffer.m_6299_(RenderType.m_110451_());
        if (!Backend.canUseInstancing((Level)be.m_58904_())) {
            SuperByteBuffer superBuffer = CachedBufferer.partial(AllPartialModels.SHAFTLESS_COGWHEEL, blockState);
            KineticBlockEntityRenderer.standardKineticRotationTransform(superBuffer, be, light);
            superBuffer.rotateCentered(Direction.UP, (float)(((Direction)blockState.m_61143_(HorizontalKineticBlock.HORIZONTAL_FACING)).m_122434_() != Direction.Axis.X ? 0.0 : 1.5707963267948966));
            superBuffer.rotateCentered(Direction.EAST, 1.5707964f);
            superBuffer.renderInto(ms, vb);
        }
        Direction targetDirection = MechanicalCrafterBlock.getTargetDirection(blockState);
        BlockPos pos = be.m_58899_();
        if ((be.covered || be.phase != MechanicalCrafterBlockEntity.Phase.IDLE) && be.phase != MechanicalCrafterBlockEntity.Phase.CRAFTING && be.phase != MechanicalCrafterBlockEntity.Phase.INSERTING) {
            SuperByteBuffer lidBuffer = this.renderAndTransform(AllPartialModels.MECHANICAL_CRAFTER_LID, blockState);
            lidBuffer.light(light).renderInto(ms, vb);
        }
        if (MechanicalCrafterBlock.isValidTarget(be.m_58904_(), pos.m_121945_(targetDirection), blockState)) {
            SuperByteBuffer beltBuffer = this.renderAndTransform(AllPartialModels.MECHANICAL_CRAFTER_BELT, blockState);
            SuperByteBuffer beltFrameBuffer = this.renderAndTransform(AllPartialModels.MECHANICAL_CRAFTER_BELT_FRAME, blockState);
            if (be.phase == MechanicalCrafterBlockEntity.Phase.EXPORTING) {
                int textureIndex = (int)((float)be.getCountDownSpeed() / 128.0f * (float)AnimationTickHolder.getTicks());
                beltBuffer.shiftUVtoSheet(AllSpriteShifts.CRAFTER_THINGIES, (float)(textureIndex % 4) / 4.0f, 0.0f, 1);
            }
            beltBuffer.light(light).renderInto(ms, vb);
            beltFrameBuffer.light(light).renderInto(ms, vb);
        } else {
            SuperByteBuffer arrowBuffer = this.renderAndTransform(AllPartialModels.MECHANICAL_CRAFTER_ARROW, blockState);
            arrowBuffer.light(light).renderInto(ms, vb);
        }
    }

    private SuperByteBuffer renderAndTransform(PartialModel renderBlock, BlockState crafterState) {
        SuperByteBuffer buffer = CachedBufferer.partial(renderBlock, crafterState);
        float xRot = ((Pointing)((Object)crafterState.m_61143_(MechanicalCrafterBlock.POINTING))).getXRotation();
        float yRot = AngleHelper.horizontalAngle((Direction)crafterState.m_61143_(HorizontalKineticBlock.HORIZONTAL_FACING));
        buffer.rotateCentered(Direction.UP, (float)((double)((yRot + 90.0f) / 180.0f) * Math.PI));
        buffer.rotateCentered(Direction.EAST, (float)((double)(xRot / 180.0f) * Math.PI));
        return buffer;
    }
}

